/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTabs;

public abstract class ItemGraveMagic
extends ItemGeneric
implements ISoulConsumer {
    protected static final String ANCIENT_NBT_BOOL = "ancient";
    protected static final String USE_COUNT_NBT_INT = "useCount";
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    ItemGraveMagic(String name, BooleanSupplier supplierBoolean) {
        super(name, ItemGraveMagic.getBuilder(), supplierBoolean);
    }

    ItemGraveMagic(String name, Item.Properties builder, BooleanSupplier supplierBoolean) {
        super(name, builder, supplierBoolean);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.func_230531_f_())).func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    public boolean isAncient(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, ANCIENT_NBT_BOOL);
    }

    protected abstract boolean doEffects(ServerWorld var1, ServerPlayerEntity var2, ItemStack var3);

    protected ItemStack onConsumeItem(PlayerEntity player, ItemStack stack) {
        int useCount = this.getUseCount(stack);
        if (useCount < 2) {
            return ItemStack.field_190927_a;
        }
        this.setUseCount(stack, --useCount);
        return stack;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (!Helper.canShowTooltip(world, stack)) {
            this.addInfoShowTooltip(list);
        }
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                this.addInfo(list, LangKey.MESSAGE_USE_LEFT, uses);
            }
            if ((cd = this.getCooldown(world, stack)) > 10) {
                this.addWarn(list, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeString(cd));
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isEnchanted(stack) && !this.isCooldown(world, stack)) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        return ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (EntityHelper.isValidPlayer(context.func_195999_j())) {
            if (this.canBlockInteractFirst(context.func_195991_k().func_180495_p(context.func_195995_a()), stack)) {
                return ActionResultType.PASS;
            }
            this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected boolean canBlockInteractFirst(BlockState state, ItemStack stack) {
        return !this.isEnchanted(stack) || ModBlocks.isDecorativeGrave(state.func_177230_c());
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity.field_70170_p.func_201670_d() && timeLeft == this.func_77626_a(stack) && this.isEnchanted(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (EntityHelper.isValidServerPlayer((Entity)entity)) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (this.isEnchanted(stack)) {
                if (this.doEffects((ServerWorld)world, player, stack)) {
                    ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundCategory.PLAYERS, world, player.func_233580_cy_(), 0.5f, 0.5f);
                    if (this.canConsumeOnUse()) {
                        stack = this.onConsumeItem((PlayerEntity)player, stack);
                    }
                    if (!stack.func_190926_b()) {
                        this.setCooldown(world, stack, this.getCastingCooldown());
                    }
                } else {
                    EntityHelper.setGlobalItemCooldown((PlayerEntity)player, this, 10);
                }
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public abstract int getCastingCooldown();

    public boolean isCooldown(World world, ItemStack stack) {
        return this.getCooldown(world, stack) > 0;
    }

    public int getCooldown(@Nullable World world, ItemStack stack) {
        long cooldown_time;
        if (world != null && stack.func_77973_b() == this && (cooldown_time = NBTStackHelper.getLong(stack, COOLDOWN_TIME_NBT_LONG, 0L)) > 0L) {
            int cd = (int)(cooldown_time - TimeHelper.worldTicks(world));
            if (cd > this.getCastingCooldown()) {
                this.setCooldown(world, stack, this.getCastingCooldown());
                return this.getCastingCooldown();
            }
            return Math.max(cd, 0);
        }
        return 0;
    }

    public void setCooldown(@Nullable World world, ItemStack stack, int time) {
        if (world != null && stack.func_77973_b() == this) {
            NBTStackHelper.setLong(stack, COOLDOWN_TIME_NBT_LONG, TimeHelper.worldTicks(world) + (long)time);
        }
    }

    public abstract int getUseMax();

    public abstract boolean canConsumeOnUse();

    public int getUseCount(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.max(0, NBTStackHelper.getInteger(stack, USE_COUNT_NBT_INT));
    }

    protected ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, USE_COUNT_NBT_INT, useCount);
        }
        return stack;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_FAILED.getText(new Object[0]);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }

    protected static Item.Properties getBuilder() {
        return new Item.Properties().func_200916_a(ModTabs.mainTab).func_200917_a(1).func_200915_b(0).func_234689_a_();
    }
}

