/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic {
    private static final String STRUCTURE_ID_NBT_STRING = "structure_id";
    private static final String STRUCTURE_POS_NBT_LOCATION = "structurePos";

    public ItemLostTablet() {
        super("lost_tablet", () -> SharedConfigTombstone.allowed_magic_items.allowLostTablet.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            Location location = this.getStructurePos(stack);
            String id = location.isOrigin() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
            this.addItemDesc(list, id, new Object[0]);
            if (!location.isOrigin()) {
                String structureRL = this.getStructureId(stack);
                if (structureRL != null) {
                    list.add(SupportStructures.getStructureName(structureRL));
                }
                this.addItemPosition(list, location);
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.func_201670_d() && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && !this.isWakeUp(stack)) {
            int cd = this.getCooldown(world, stack);
            if (cd <= 0) {
                this.setCooldown(world, stack, TimeHelper.tickFromSecond(Helper.getRandom(500, 800)));
            } else if (cd == 1) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                boolean success = this.wakeUpMagic(player, stack);
                if (success) {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[0]);
                } else if (Helper.random.nextBoolean()) {
                    this.setCooldown(world, stack, TimeHelper.tickFromSecond(Helper.getRandom(1500, 1800)));
                } else {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    stack.func_190918_g(1);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)ModItems.grave_dust, Helper.getRandom(3, 5)));
                    player.field_71069_bz.func_75142_b();
                }
            }
        }
    }

    @Override
    public int getCooldown(@Nullable World world, ItemStack stack) {
        long cooldown_time;
        if (world != null && stack.func_77973_b() == this && (cooldown_time = NBTStackHelper.getLong(stack, "cooldown_time", 0L)) > 0L) {
            int cd = (int)(cooldown_time - TimeHelper.worldTicks(world));
            if (cd > 1800) {
                this.setCooldown(world, stack, 1800);
                return 1800;
            }
            return Math.max(cd, 0);
        }
        return 0;
    }

    private boolean wakeUpMagic(ServerPlayerEntity player, ItemStack stack) {
        Structure<?> structure;
        ServerWorld world;
        boolean noStructureInCurrentWorld;
        String structureRLString = Helper.getRandom(1, 100) < 60 - EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.treasure_seeker) * 10 ? SupportStructures.VILLAGE.getId() : ((Boolean)ConfigTombstone.decorative_grave.lostTabletSearchModdedStructure.get() != false ? SupportStructures.getRandomStructure(p -> !SupportStructures.VILLAGE.is((ResourceLocation)p) && !Helper.containRL((List)ConfigTombstone.decorative_grave.lostTabletDeniedStructures.get(), p)) : SupportStructures.getRandomVanillaStructure(p -> !SupportStructures.VILLAGE.is((ResourceLocation)p)));
        if (structureRLString == null) {
            structureRLString = SupportStructures.VILLAGE.getId();
        }
        boolean bl = noStructureInCurrentWorld = !SupportStructures.hasStructureInWorld(world = player.func_71121_q(), structure = SupportStructures.getStructure(structureRLString));
        if (noStructureInCurrentWorld || Helper.random.nextFloat() < 0.3f) {
            if (((Boolean)ConfigTombstone.decorative_grave.lostTabletSearchOutsideWorld.get()).booleanValue()) {
                RegistryKey<World> dimension = Helper.getRandomInList(SupportStructures.getDimensionTypesForStructure(world.func_73046_m(), structure));
                if (dimension != null) {
                    world = world.func_73046_m().func_71218_a(dimension);
                } else if (noStructureInCurrentWorld) {
                    return false;
                }
            } else if (noStructureInCurrentWorld) {
                return false;
            }
        }
        int radius = 5000;
        Location location = Helper.findNearestStructure(world, new BlockPos(player.func_226277_ct_() + Helper.random.nextGaussian() * (double)radius, (double)SupportStructures.getY(structureRLString), player.func_226281_cx_() + Helper.random.nextGaussian() * (double)radius), structureRLString, true);
        if (location.isOrigin() || !Helper.isValidPos((World)world, location.getPos())) {
            return false;
        }
        NBTStackHelper.setLocation(stack, STRUCTURE_POS_NBT_LOCATION, location);
        NBTStackHelper.setString(stack, STRUCTURE_ID_NBT_STRING, structureRLString);
        (SupportStructures.VILLAGE.getId().equals(structureRLString) ? ModTriggers.FIND_LOST_TABLET_VILLAGE : ModTriggers.FIND_LOST_TABLET_TREASURE).trigger(player);
        return true;
    }

    @Nullable
    public String getStructureId(ItemStack stack) {
        String structureId;
        CompoundNBT tag;
        if (stack.func_77973_b() == this && (tag = stack.func_77978_p()) != null && !(structureId = NBTStackHelper.getString(stack, STRUCTURE_ID_NBT_STRING)).isEmpty()) {
            return structureId;
        }
        return null;
    }

    public boolean isWakeUp(ItemStack stack) {
        return this.getStructureId(stack) != null;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return super.canEnchant(world, gravePos, player, stack) && this.isWakeUp(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (this.isWakeUp(stack)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack) {
        Location location = this.getStructurePos(stack);
        String structureId = this.getStructureId(stack);
        if (structureId == null || location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((World)world)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((PlayerEntity)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        ServerWorld targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (!Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((PlayerEntity)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        Location spawnLoc = new SpawnHelper(targetWorld, location.getPos()).findStructurePlace(structureId);
        if (spawnLoc.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((PlayerEntity)player, new Object[0]);
            this.resetStack((World)world, stack);
            return false;
        }
        EntityHelper.setGlobalItemCooldown((PlayerEntity)player, this, 10);
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.setLocation(stack, STRUCTURE_POS_NBT_LOCATION, spawnLoc);
        CallbackHandler.addCallback(1, () -> {
            PlayerEntity newPlayer = (PlayerEntity)Helper.teleportEntity(player, spawnLoc, targetWorld);
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
            ModTriggers.USE_LOST_TABLET.trigger(player);
        });
        return true;
    }

    private void resetStack(World world, ItemStack stack) {
        this.setCooldown(world, stack, TimeHelper.tickFromMinute(10));
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.removeLocation(stack, STRUCTURE_POS_NBT_LOCATION);
    }

    public Location getStructurePos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, STRUCTURE_POS_NBT_LOCATION);
        }
        return Location.ORIGIN;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }
}

