/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.function.BooleanSupplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModPerks;

public abstract class ItemTablet
extends ItemGraveMagic {
    public ItemTablet(String name, BooleanSupplier supplierBoolean) {
        super(name, supplierBoolean);
    }

    @Override
    public int getUseMax() {
        return (Integer)SharedConfigTombstone.decorative_grave.tabletMaxUse.get();
    }

    @Override
    public int getCastingCooldown() {
        return TimeHelper.tickFromSecond((Integer)SharedConfigTombstone.decorative_grave.tabletCooldown.get());
    }

    @Override
    public boolean canConsumeOnUse() {
        return true;
    }

    @Override
    protected ItemStack onConsumeItem(PlayerEntity player, ItemStack stack) {
        if (Helper.getRandom(1, 10) <= EntityHelper.getPerkLevelWithBonus(player, ModPerks.rune_inscriber)) {
            return stack;
        }
        return super.onConsumeItem(player, stack);
    }

    public ItemStack createAncient() {
        return NBTStackHelper.setBoolean(new ItemStack((IItemProvider)this), "ancient", true);
    }
}

