/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final String POPPET_PROT_PREFIX = "poppet_prot_";

    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder(true).func_234689_a_(), () -> SharedConfigTombstone.allowed_magic_items.allowVoodooPoppet.get());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.func_230531_f_()).func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            List<DamageType> damageTypes = ItemVoodooPoppet.getValidDamageTypes().filter(d -> this.hasProtection(stack, (DamageType)((Object)d))).collect(Collectors.toList());
            damageTypes.forEach(d -> list.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + "." + d.func_176610_l()).func_240703_c_(StyleType.TOOLTIP_ITEM)));
            this.addItemUse(list, this.isEnchanted(stack) ? "3" : (damageTypes.isEmpty() ? "1" : "2"), new Object[0]);
            if (EntityHelper.getPerkLevelWithBonus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModPerks.voodoo_poppet) <= 0) {
                this.addWarn(list, LangKey.MESSAGE_PERK_REQUIRED, ModPerks.voodoo_poppet.getTranslation().func_230531_f_().func_240703_c_(StyleType.TOOLTIP_ITEM));
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_SUCCESS.getText(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_VOODOO_POPPET_FAILED.getText(new Object[0]);
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrenght) {
        if (!this.isEnchanted(stack) && ItemVoodooPoppet.getValidDamageTypes().anyMatch(p -> this.hasProtection(stack, (DamageType)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return 1;
        }
        return 0;
    }

    public ItemStack createWithRandomProtections(int count) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(new ItemStack((IItemProvider)this), count), "enchant", true);
    }

    public static Stream<DamageType> getValidDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, DamageType.COLD.ordinal() + 1);
    }

    public Stream<DamageType> getCraftableDamageTypes() {
        return Arrays.stream(DamageType.values(), 0, DamageType.DARKNESS.ordinal() + 1);
    }

    public ItemStack addProtection(ItemStack stack, DamageType damageType) {
        if (stack.func_77973_b() == this && !this.isEnchanted(stack) && !this.hasProtection(stack, damageType)) {
            NBTStackHelper.setBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal(), true);
        }
        return stack;
    }

    public boolean hasProtection(ItemStack stack, DamageType damageType) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    private boolean removeProtection(ItemStack stack, DamageType damageType) {
        return NBTStackHelper.removeKeyName(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    public boolean preventDeath(PlayerEntity player, ItemStack stack, DamageType damageType) {
        if (this.canPreventDeath(stack, damageType) && this.removeProtection(stack, damageType)) {
            NBTStackHelper.setBoolean(stack, "enchant", false);
            int duration = TimeHelper.tickFromSecond((Integer)ConfigTombstone.decorative_grave.durationVoodooPoppetEffects.get());
            switch (damageType) {
                case SUFFOCATION: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76427_o, duration);
                    break;
                }
                case BURN: {
                    player.func_70066_B();
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76426_n, duration);
                    break;
                }
                case LIGHTNING: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, ModEffects.lightning_resistance, duration);
                    break;
                }
                case FALL: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, ModEffects.feather_fall, duration);
                    break;
                }
                case DARKNESS: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76443_y, duration);
                    EffectHelper.clearBadEffects((LivingEntity)player);
                    break;
                }
                case COLD: {
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76428_l, duration, 9, new boolean[0]);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76422_e, duration);
                    EffectHelper.addEffect((LivingEntity)player, Effects.field_76424_c, duration);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean canPreventDeath(ItemStack stack, DamageType damageType) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, POPPET_PROT_PREFIX + damageType.ordinal());
    }

    @Nullable
    public DamageType getPoppetProtection(DamageSource srcDmg) {
        DamageType damageType = DamageType.of(srcDmg);
        return ItemVoodooPoppet.getValidDamageTypes().filter(d -> d == damageType).findFirst().orElse(null);
    }

    private ItemStack setRandomProtections(ItemStack stack, int count) {
        int limit = DamageType.COLD.ordinal() + 1;
        List<DamageType> damages = ItemVoodooPoppet.getValidDamageTypes().collect(Collectors.toList());
        if (count < limit) {
            ArrayList list = new ArrayList();
            for (int i = 0; i < count; ++i) {
                list.add(damages.remove(Helper.random.nextInt(damages.size())));
            }
            damages = list;
        }
        damages.forEach(d -> this.addProtection(stack, (DamageType)((Object)d)));
        return stack;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        return NBTStackHelper.setBoolean(this.setRandomProtections(stack, Helper.random.nextInt(5) + 1), "enchant", true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

