/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.api.magic.ProtectedEntityProvider;
import ovh.corail.tombstone.helper.Helper;

public class SyncProtectionMessage {
    private int entityId;
    private boolean active;

    public SyncProtectionMessage(int entityId, boolean active) {
        this.entityId = entityId;
        this.active = active;
    }

    static SyncProtectionMessage fromBytes(PacketBuffer buf) {
        return new SyncProtectionMessage(buf.readInt(), buf.readBoolean());
    }

    static void toBytes(SyncProtectionMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeBoolean(msg.active);
    }

    public static class Handler {
        static void handle(final SyncProtectionMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Entity entity;
                        Entity entity2 = entity = Minecraft.func_71410_x().field_71441_e != null ? Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId) : null;
                        if (entity instanceof LivingEntity) {
                            entity.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).ifPresent(cap -> cap.apply((LivingEntity)entity, msg.active));
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

