/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;

public class UpdateClientMessage {
    private BlockPos spawnPos;
    private int range;
    private boolean dateAroundHalloween;
    private boolean isAprilFoolsDay;
    private boolean isContributor;

    public UpdateClientMessage(BlockPos spawnPos, int range, boolean dateAroundHalloween, boolean isAprilFoolsDay, boolean isContributor) {
        this.spawnPos = spawnPos;
        this.range = range;
        this.dateAroundHalloween = dateAroundHalloween;
        this.isAprilFoolsDay = isAprilFoolsDay;
        this.isContributor = isContributor;
    }

    static UpdateClientMessage fromBytes(PacketBuffer buf) {
        return new UpdateClientMessage(BlockPos.func_218283_e((long)buf.readLong()), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    static void toBytes(UpdateClientMessage msg, PacketBuffer buf) {
        buf.writeLong(msg.spawnPos.func_218275_a());
        buf.writeInt(msg.range);
        buf.writeBoolean(msg.dateAroundHalloween);
        buf.writeBoolean(msg.isAprilFoolsDay);
        buf.writeBoolean(msg.isContributor);
    }

    public static class Handler {
        static void handle(UpdateClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    SpawnProtectionHandler.getInstance().setSpawnProtection(message.spawnPos, message.range);
                    Helper.isHalloween = message.dateAroundHalloween;
                    Helper.isAprilFools = message.isAprilFoolsDay;
                    Helper.isContributor = message.isContributor;
                    PacketHandler.sendToServer(new UpdateServerMessage(ModTombstone.PROXY.initPlayerPreference(), true));
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

