/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModTriggers;

public class UpdateServerMessage {
    private PlayerPreference playerPreference;
    private boolean isLogin;

    public UpdateServerMessage(PlayerPreference playerPreference, boolean isLogin) {
        this.playerPreference = playerPreference;
        this.isLogin = isLogin;
    }

    static UpdateServerMessage fromBytes(PacketBuffer buf) {
        return new UpdateServerMessage(PlayerPreference.fromBytes(buf), buf.readBoolean());
    }

    static void toBytes(UpdateServerMessage msg, PacketBuffer buf) {
        PlayerPreference.toBytes(msg.playerPreference, buf);
        buf.writeBoolean(msg.isLogin);
    }

    public static class Handler {
        static void handle(UpdateServerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    ServerPlayerEntity player = ctx.getSender();
                    if (player != null) {
                        PlayerPreference oldPlayerPreference = PlayerPreference.get(player.func_110124_au());
                        PlayerPreference.set(player, message.playerPreference);
                        if (!message.isLogin && !message.playerPreference.hasSameFavoriteGrave(oldPlayerPreference)) {
                            ModTriggers.CHOOSE_GRAVE_TYPE.trigger(player);
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

