/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGraveSoul
extends SpriteTexturedParticle {
    private final IAnimatedSprite spriteSet;
    private final double radius;
    private final double centerX;
    private final double centerZ;
    private final float[] colorCode;

    private ParticleGraveSoul(IAnimatedSprite spriteSet, ClientWorld world, double x, double y, double z, int soulTypeId) {
        super(world, x, y + 0.85, z);
        this.field_70547_e = 100;
        this.field_70544_f = soulTypeId > 1 ? 0.04f : 0.03f;
        this.centerX = x + 0.5;
        this.centerZ = z + 0.5;
        this.radius = 0.3;
        this.colorCode = Helper.getRGBColor3F(SoulType.byId(soulTypeId).getColorCode());
        this.func_82338_g(0.5f);
        this.func_70538_b(this.colorCode[0], this.colorCode[1], this.colorCode[2]);
        this.updatePosition();
        this.field_190017_n = false;
        this.spriteSet = spriteSet;
        this.func_217566_b(this.spriteSet);
    }

    private void updatePosition() {
        double ratio = (double)this.field_70546_d / (double)this.field_70547_e;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_187123_c = this.field_187126_f = this.centerX + this.radius * Math.cos(Math.PI * 2 * ratio);
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h = this.centerZ + this.radius * Math.sin(Math.PI * 2 * ratio);
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.func_187113_k()) {
            this.func_217566_b(this.spriteSet);
            this.updatePosition();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBlinkingAura(this.field_187122_b, this.field_187126_f, this.field_187127_g + 0.02, this.field_187128_h, this.colorCode));
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(BasicParticleType type, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ParticleGraveSoul(this.spriteSet, world, x, y, z, (int)motionX);
        }
    }
}

