/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.lang.ref.WeakReference;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
public class ParticleShield
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/item/pray_of_protection.png");
    static final double TWO_PI = Math.PI * 2;
    private final WeakReference<LivingEntity> entityWeakReference;
    private final double angle;
    private final double radius;
    private final double yHeight;

    public ParticleShield(ClientWorld world, LivingEntity entity, double angle) {
        this(world, entity, angle, 0.5, 0.3);
    }

    ParticleShield(ClientWorld world, LivingEntity entity, double angle, double radius, double yHeight) {
        super(world, ParticleShield.getPos(entity, angle, radius, yHeight));
        this.isSolid = true;
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.angle = angle;
        this.radius = radius;
        this.yHeight = yHeight;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_70546_d = 1;
        this.field_70547_e = 20;
        this.field_70544_f = 0.15f;
        this.field_190017_n = false;
        this.field_70545_g = 0.0f;
    }

    private static Vector3d getPos(LivingEntity entity, double angle, double radius, double yHeight) {
        double ratio = (double)(entity.field_70173_aa % 100) / 100.0;
        return entity.func_213303_ch().func_72441_c(radius * Math.cos(Math.PI * 2 * (angle + ratio)), yHeight, radius * Math.sin(Math.PI * 2 * (angle + ratio)));
    }

    public void func_189213_a() {
        LivingEntity entity = (LivingEntity)this.entityWeakReference.get();
        if (entity == null || this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        Vector3d pos = ParticleShield.getPos(entity, this.angle, this.radius, this.yHeight);
        this.field_187126_f = pos.field_72450_a;
        this.field_187127_g = pos.field_72448_b;
        this.field_187128_h = pos.field_72449_c;
    }

    @Override
    ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

