/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.proxy;

import java.net.Proxy;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;
import ovh.corail.tombstone.particle.ParticleBoneShield;
import ovh.corail.tombstone.particle.ParticleCasting;
import ovh.corail.tombstone.particle.ParticleShadowStep;
import ovh.corail.tombstone.particle.ParticleShield;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModParticleTypes;
import ovh.corail.tombstone.render.RenderWritableGrave;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements IProxy {
    private boolean isConfigDirty = false;
    private PlayerPreference lastPlayerPreference;

    @Override
    public void preInit() {
        ClientRegistry.bindTileEntityRenderer(ModBlocks.tile_decorative_grave, RenderWritableGrave::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.tile_grave, RenderWritableGrave::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void produceGraveSmoke(World world, double x, double y, double z) {
        for (int i = 0; i < ((ConfigTombstone.Client.FogDensity)((Object)ConfigTombstone.client.fogDensity.get())).ordinal(); ++i) {
            Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ModParticleTypes.GRAVE_SMOKE, x + world.field_73012_v.nextGaussian(), y, z + world.field_73012_v.nextGaussian(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void produceShadowStep(LivingEntity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.equals((Object)entity) && mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
            return;
        }
        if (mc.field_71441_e != null && !entity.func_184218_aH() && !entity.func_70608_bn()) {
            IntStream.rangeClosed(1, 6).forEach(i -> mc.field_71452_i.func_78873_a((Particle)new ParticleShadowStep(mc.field_71441_e, entity, (double)i / 6.0)));
        }
    }

    @Override
    public void produceShield(LivingEntity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !entity.func_184218_aH() && !entity.func_70608_bn()) {
            IntStream.rangeClosed(1, 4).forEach(i -> mc.field_71452_i.func_78873_a((Particle)new ParticleShield(mc.field_71441_e, entity, 0.25 * (double)i)));
        }
    }

    @Override
    public void produceBoneShield(LivingEntity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !entity.func_184218_aH() && !entity.func_70608_bn()) {
            IntStream.rangeClosed(1, 5).forEach(i -> mc.field_71452_i.func_78873_a((Particle)new ParticleBoneShield(mc.field_71441_e, entity, 0.2 * (double)i, i % 2 == 0)));
        }
    }

    @Override
    public void produceGraveSoul(World world, BlockPos pos, SoulType soulType) {
        world.func_195594_a((IParticleData)ModParticleTypes.GRAVE_SOUL, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)soulType.ordinal(), 0.0, 0.0);
    }

    @Override
    public void produceParticleCasting(LivingEntity caster, Predicate<LivingEntity> predic) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (caster != null && world != null) {
            for (int i = 1; i <= 2; ++i) {
                ParticleCasting particle = new ParticleCasting(world, caster, predic, 0.0, (double)i * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(world, caster, predic, 0.5, (double)(i + 1) * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(world, caster, predic, 1.0, (double)i * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(world, caster, predic, 1.5, (double)(i + 1) * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
                particle = new ParticleCasting(world, caster, predic, 2.0, (double)i * 0.5);
                mc.field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void produceSmokeColumn(World world, Vector3d vec) {
        world.func_195594_a((IParticleData)ModParticleTypes.SMOKE_COLUMN, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0);
    }

    @Override
    public Proxy getNetProxy() {
        return Minecraft.func_71410_x().func_110437_J();
    }

    @Override
    public void markConfigDirty() {
        this.isConfigDirty = true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.isConfigDirty) {
            this.isConfigDirty = false;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
            } else if (this.lastPlayerPreference.hasChangedFromConfig()) {
                LangKey.sendMessage((ITextComponent)new StringTextComponent("Syncing Preferences on Server"), (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                this.lastPlayerPreference = PlayerPreference.fromClientConfig();
                PacketHandler.sendToServer(new UpdateServerMessage(this.lastPlayerPreference, false));
            }
        }
    }

    @Override
    public PlayerPreference initPlayerPreference() {
        this.lastPlayerPreference = PlayerPreference.fromClientConfig();
        return this.lastPlayerPreference;
    }
}

