/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import java.util.function.Function;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.recipe.DisableableShapelessRecipe;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSerializers;

public class RecipeEnchantedGraveKey
extends DisableableShapelessRecipe {
    private static Function<ItemStack, ItemStack> APPLY_LOCATION_ZERO = stack -> NBTStackHelper.setLocation(stack, "tombPos", new Location(0, 0, 0, (RegistryKey<World>)World.field_234918_g_));

    public RecipeEnchantedGraveKey(ShapelessRecipe recipe) {
        super(RecipeEnchantedGraveKey.adapt(recipe));
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack key = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.grave_key) continue;
            if (!key.func_190926_b() || NBTStackHelper.getBoolean(stack, "enchant")) {
                return ItemStack.field_190927_a;
            }
            key = stack;
        }
        return key.func_190926_b() ? ItemStack.field_190927_a : NBTStackHelper.setBoolean(key.func_77946_l(), "enchant", true);
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return ModSerializers.ENCHANTED_GRAVE_KEY;
    }

    private static ShapelessRecipe adapt(ShapelessRecipe recipe) {
        APPLY_LOCATION_ZERO.apply(recipe.func_77571_b());
        return Helper.setNBTIngredients(recipe, ModItems.grave_key, APPLY_LOCATION_ZERO, false);
    }
}

