/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.Registrable;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static final EnumMap<GraveModel, Block> graves = new EnumMap(GraveModel.class);
    public static final EnumMap<GraveModel, Block> decorative_graves = new EnumMap(GraveModel.class);
    @ObjectHolder(value="tombstone:tile_decorative_grave")
    public static TileEntityType<TileEntityDecorativeGrave> tile_decorative_grave;
    @ObjectHolder(value="tombstone:tile_grave")
    public static TileEntityType<TileEntityPlayerGrave> tile_grave;
    @ObjectHolder(value="tombstone:dark_marble")
    public static final Block dark_marble;
    @ObjectHolder(value="tombstone:white_marble")
    public static final Block white_marble;

    public static boolean isPlayerGrave(Block block) {
        return graves.containsValue(block);
    }

    public static boolean isDecorativeGrave(Block block) {
        return decorative_graves.containsValue(block);
    }

    public static boolean isAnyGrave(Block block) {
        return ModBlocks.isPlayerGrave(block) || ModBlocks.isDecorativeGrave(block);
    }

    @SubscribeEvent
    public static void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{(TileEntityType)TileEntityType.Builder.func_223042_a(TileEntityDecorativeGrave::new, (Block[])decorative_graves.values().toArray(new Block[0])).func_206865_a(null).setRegistryName("tombstone", "tile_decorative_grave"), (TileEntityType)TileEntityType.Builder.func_223042_a(TileEntityPlayerGrave::new, (Block[])graves.values().toArray(new Block[0])).func_206865_a(null).setRegistryName("tombstone", "tile_grave")});
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        for (GraveModel graveModel : GraveModel.values()) {
            graves.put(graveModel, (Block)Registrable.register(event.getRegistry(), new BlockGrave(graveModel), graveModel.func_176610_l()));
            decorative_graves.put(graveModel, (Block)Registrable.register(event.getRegistry(), new BlockDecorativeGrave(graveModel), "decorative_" + graveModel.func_176610_l()));
        }
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.DARK), "dark_marble");
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.WHITE), "white_marble");
    }

    @SubscribeEvent
    public static void registerItemBlock(RegistryEvent.Register<Item> event) {
        for (GraveModel graveModel : GraveModel.values()) {
            Block decorativeGrave = decorative_graves.get((Object)graveModel);
            Registrable.register(event.getRegistry(), new ItemBlockGrave(decorativeGrave), decorativeGrave.getRegistryName());
        }
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble, new Item.Properties().func_200916_a(ModTabs.mainTab)), dark_marble.getRegistryName());
        Registrable.register(event.getRegistry(), new BlockItem(white_marble, new Item.Properties().func_200916_a(ModTabs.mainTab)), white_marble.getRegistryName());
    }

    static {
        dark_marble = Blocks.field_150350_a;
        white_marble = Blocks.field_150350_a;
    }
}

