/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.recipe.DisableableShapedRecipe;
import ovh.corail.tombstone.recipe.DisableableShapelessRecipe;
import ovh.corail.tombstone.recipe.RecipeEnchantedGraveKey;
import ovh.corail.tombstone.recipe.RecipeFamiliarReceptacle;
import ovh.corail.tombstone.recipe.RecipeImpregnatedDiamondWithNeedle;
import ovh.corail.tombstone.recipe.RecipeVoodooPoppetProtection;
import ovh.corail.tombstone.recipe.ShapedSerializer;
import ovh.corail.tombstone.recipe.ShapelessSerializer;
import ovh.corail.tombstone.registry.Registrable;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModSerializers {
    public static final IRecipeSerializer<DisableableShapelessRecipe> DISABLEABLE_SHAPELESS = new ShapelessSerializer<DisableableShapelessRecipe>(DisableableShapelessRecipe::new);
    public static final IRecipeSerializer<DisableableShapedRecipe> DISABLEABLE_SHAPED = new ShapedSerializer<DisableableShapedRecipe>(DisableableShapedRecipe::new);
    public static final IRecipeSerializer<RecipeEnchantedGraveKey> ENCHANTED_GRAVE_KEY = new ShapelessSerializer<RecipeEnchantedGraveKey>(RecipeEnchantedGraveKey::new);
    public static final IRecipeSerializer<RecipeFamiliarReceptacle> FAMILIAR_RECEPTACLE = new ShapedSerializer<RecipeFamiliarReceptacle>(RecipeFamiliarReceptacle::new);
    public static final IRecipeSerializer<RecipeVoodooPoppetProtection> VOODOO_POPPET_PROTECTION = new ShapelessSerializer<RecipeVoodooPoppetProtection>(RecipeVoodooPoppetProtection::new);
    public static final IRecipeSerializer<RecipeImpregnatedDiamondWithNeedle> IMPREGNATED_DIAMOND_WITH_NEEDLE = new SpecialRecipeSerializer(RecipeImpregnatedDiamondWithNeedle::new);

    @SubscribeEvent
    public static void onRegisterSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        Registrable.register(event.getRegistry(), DISABLEABLE_SHAPELESS, "disableable_shapeless");
        Registrable.register(event.getRegistry(), DISABLEABLE_SHAPED, "disableable_shaped");
        Registrable.register(event.getRegistry(), ENCHANTED_GRAVE_KEY, "enchanted_grave_key");
        Registrable.register(event.getRegistry(), VOODOO_POPPET_PROTECTION, "voodoo_poppet_protection");
        Registrable.register(event.getRegistry(), FAMILIAR_RECEPTACLE, "familiar_receptacle");
        Registrable.register(event.getRegistry(), IMPREGNATED_DIAMOND_WITH_NEEDLE, "impregnated_diamond_with_needle");
    }
}

