/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.TradeSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goblintraders")
public class TradeManager
implements IFutureReloadListener {
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON = new GsonBuilder().create();
    private static TradeManager instance;
    private List<EntityType<?>> traders = new ArrayList();
    private Map<EntityType<?>, EntityTrades> tradeMap = new HashMap();
    private Map<ResourceLocation, TradeSerializer<?>> tradeSerializer = new HashMap();

    public static TradeManager instance() {
        if (instance == null) {
            instance = new TradeManager();
        }
        return instance;
    }

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)TradeManager.instance());
    }

    public void registerTrader(EntityType<? extends TraderCreatureEntity> type) {
        if (!this.traders.contains(type)) {
            this.traders.add(type);
        }
    }

    @Nullable
    public EntityTrades getTrades(EntityType<? extends TraderCreatureEntity> type) {
        return this.tradeMap.get(type);
    }

    public void registerTypeSerializer(TradeSerializer<?> serializer) {
        this.tradeSerializer.putIfAbsent(serializer.getId(), serializer);
    }

    @Nullable
    public TradeSerializer<?> getTypeSerializer(ResourceLocation id) {
        return this.tradeSerializer.get(id);
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager manager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        HashMap entityToResourceList = new HashMap();
        return CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.traders.forEach(entityType -> {
            String folder = String.format("trades/%s", Objects.requireNonNull(entityType.getRegistryName()).func_110623_a());
            ArrayList resources = new ArrayList(manager.func_199003_a(folder, fileName -> fileName.endsWith(".json")));
            resources.sort((r1, r2) -> {
                if (r1.func_110624_b().equals(r2.func_110624_b())) {
                    return 0;
                }
                return r2.func_110624_b().equals("goblintraders") ? 1 : -1;
            });
            EnumMap tradeResources = new EnumMap(TradeRarity.class);
            Arrays.stream(TradeRarity.values()).forEach(rarity -> tradeResources.put((TradeRarity)((Object)((Object)((Object)rarity))), new LinkedHashSet()));
            resources.forEach(resource -> {
                String path = resource.func_110623_a().substring(0, resource.func_110623_a().length() - FILE_TYPE_LENGTH_VALUE);
                String[] splitPath = path.split("/");
                if (splitPath.length != 3) {
                    return;
                }
                Arrays.stream(TradeRarity.values()).forEach(rarity -> {
                    if (rarity.getKey().equals(splitPath[2])) {
                        ((LinkedHashSet)tradeResources.get(rarity)).add(resource);
                    }
                });
            });
            EntityTrades.Builder builder = EntityTrades.Builder.create();
            Arrays.stream(TradeRarity.values()).forEach(rarity -> this.deserializeTrades(manager, builder, (TradeRarity)((Object)((Object)((Object)rarity))), (LinkedHashSet)tradeResources.get(rarity)));
            entityToResourceList.put(entityType, builder.build());
            this.tradeMap = ImmutableMap.copyOf((Map)entityToResourceList);
        }), backgroundExecutor)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0));
    }

    private void deserializeTrades(IResourceManager manager, EntityTrades.Builder builder, TradeRarity rarity, LinkedHashSet<ResourceLocation> resources) {
        for (ResourceLocation resource : resources) {
            try {
                InputStream inputstream = manager.func_199002_a(resource).func_199027_b();
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        JsonObject object = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                        builder.deserialize(rarity, object);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputstream == null) continue;
                    if (throwable != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputstream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

