/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.world.spawner.GoblinTraderSpawner;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

@Mod.EventBusSubscriber(modid="goblintraders")
public class SpawnHandler {
    private static Map<ResourceLocation, GoblinTraderSpawner> spawners = new HashMap<ResourceLocation, GoblinTraderSpawner>();

    @SubscribeEvent
    public static void onServerStart(FMLServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        spawners.put(DimensionType.field_242710_a, new GoblinTraderSpawner(server, "GoblinTrader", (EntityType<? extends AbstractGoblinEntity>)((EntityType)ModEntities.GOBLIN_TRADER.get()), Config.COMMON.goblinTrader));
        spawners.put(DimensionType.field_242711_b, new GoblinTraderSpawner(server, "VeinGoblinTrader", (EntityType<? extends AbstractGoblinEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()), Config.COMMON.veinGoblinTrader));
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerStoppedEvent event) {
        spawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        GoblinTraderSpawner spawner = spawners.get(event.world.func_234923_W_().func_240901_a_());
        if (spawner != null) {
            spawner.tick(event.world);
        }
    }
}

