/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics;

import javax.annotation.Nullable;
import knightminer.ceramics.ClientEvents;
import knightminer.ceramics.Registration;
import knightminer.ceramics.datagen.BlockTagProvider;
import knightminer.ceramics.datagen.FluidTagProvider;
import knightminer.ceramics.datagen.ItemTagProvider;
import knightminer.ceramics.datagen.LootTableProvider;
import knightminer.ceramics.datagen.RecipeProvider;
import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.recipe.CeramicsTags;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;

@Mod(value="ceramics")
public class Ceramics {
    public static final String MOD_ID = "ceramics";
    public static final Logger LOG = LogManager.getLogger((String)"ceramics");

    public Ceramics() {
        Registration.init();
        CeramicsTags.init();
        CeramicsNetwork.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::gatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::onConstructor);
        MinecraftForge.EVENT_BUS.addGenericListener(Block.class, this::onMissingBlocks);
        MinecraftForge.EVENT_BUS.addGenericListener(Item.class, this::onMissingItems);
    }

    private void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator gen = event.getGenerator();
            ExistingFileHelper helper = event.getExistingFileHelper();
            BlockTagProvider blockTags = new BlockTagProvider(gen, helper);
            gen.func_200390_a((IDataProvider)blockTags);
            gen.func_200390_a((IDataProvider)new ItemTagProvider(gen, blockTags, helper));
            gen.func_200390_a((IDataProvider)new FluidTagProvider(gen, helper));
            gen.func_200390_a((IDataProvider)new RecipeProvider(gen));
            gen.func_200390_a((IDataProvider)new LootTableProvider(gen));
        }
    }

    @Nullable
    private Block missingBlock(String name) {
        if ("gauge".equals(name)) {
            return (Block)Registration.TERRACOTTA_GAUGE.get();
        }
        return null;
    }

    private void onMissingBlocks(RegistryEvent.MissingMappings<Block> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, this::missingBlock);
    }

    private void onMissingItems(RegistryEvent.MissingMappings<Item> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, name -> {
            Block provider = this.missingBlock((String)name);
            return provider == null ? null : provider.func_199767_j();
        });
    }

    public static String locationName(String name) {
        return "ceramics:" + name;
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static String lang(String group, String name) {
        return String.format("%s.%s.%s", group, MOD_ID, name);
    }
}

