/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import java.util.EnumMap;
import java.util.Map;
import knightminer.ceramics.blocks.ChannelBlock;
import knightminer.ceramics.recipe.CeramicsTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CisternBlock
extends Block {
    public static final Map<Direction, BooleanProperty> CONNECTIONS = (Map)Util.func_200696_a(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, BlockStateProperties.field_208151_D);
        map.put(Direction.SOUTH, BlockStateProperties.field_208153_F);
        map.put(Direction.WEST, BlockStateProperties.field_208154_G);
        map.put(Direction.EAST, BlockStateProperties.field_208152_E);
    });
    public static final BooleanProperty EXTENSION = BooleanProperty.func_177716_a((String)"extension");
    private static final VoxelShape[] BOUNDS_BASE;
    private static final VoxelShape[] BOUNDS_EXTENSION;
    private static final VoxelShape SOLIDNESS_BASE;
    private static final VoxelShape SOLIDNESS_EXTENSION;

    private static int boundsKey(boolean north, boolean south, boolean west, boolean east) {
        return (east ? 8 : 0) | (north ? 4 : 0) | (west ? 2 : 0) | (south ? 1 : 0);
    }

    private static VoxelShape[] makeBounds(VoxelShape base) {
        VoxelShape connectionNorth = CisternBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0);
        VoxelShape connectionSouth = CisternBlock.func_208617_a((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0);
        VoxelShape connectionWest = CisternBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0);
        VoxelShape connectionEast = CisternBlock.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        boolean[] bools = new boolean[]{false, true};
        VoxelShape[] boundList = new VoxelShape[16];
        for (boolean north : bools) {
            for (boolean south : bools) {
                for (boolean west : bools) {
                    for (boolean east : bools) {
                        VoxelShape bounds = base;
                        if (north) {
                            bounds = VoxelShapes.func_197872_a((VoxelShape)bounds, (VoxelShape)connectionNorth);
                        }
                        if (south) {
                            bounds = VoxelShapes.func_197872_a((VoxelShape)bounds, (VoxelShape)connectionSouth);
                        }
                        if (west) {
                            bounds = VoxelShapes.func_197872_a((VoxelShape)bounds, (VoxelShape)connectionWest);
                        }
                        if (east) {
                            bounds = VoxelShapes.func_197872_a((VoxelShape)bounds, (VoxelShape)connectionEast);
                        }
                        boundList[CisternBlock.boundsKey((boolean)north, (boolean)south, (boolean)west, (boolean)east)] = bounds.func_197753_c();
                    }
                }
            }
        }
        return boundList;
    }

    public CisternBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{EXTENSION});
        for (Direction side : Direction.Plane.HORIZONTAL) {
            builder.func_206894_a(new Property[]{(Property)CONNECTIONS.get(side)});
        }
    }

    @Deprecated
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208151_D, state.func_177229_b((Property)BlockStateProperties.field_208153_F))).func_206870_a((Property)BlockStateProperties.field_208152_E, state.func_177229_b((Property)BlockStateProperties.field_208154_G))).func_206870_a((Property)BlockStateProperties.field_208153_F, state.func_177229_b((Property)BlockStateProperties.field_208151_D))).func_206870_a((Property)BlockStateProperties.field_208154_G, state.func_177229_b((Property)BlockStateProperties.field_208152_E));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208151_D, state.func_177229_b((Property)BlockStateProperties.field_208152_E))).func_206870_a((Property)BlockStateProperties.field_208152_E, state.func_177229_b((Property)BlockStateProperties.field_208153_F))).func_206870_a((Property)BlockStateProperties.field_208153_F, state.func_177229_b((Property)BlockStateProperties.field_208154_G))).func_206870_a((Property)BlockStateProperties.field_208154_G, state.func_177229_b((Property)BlockStateProperties.field_208151_D));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208151_D, state.func_177229_b((Property)BlockStateProperties.field_208154_G))).func_206870_a((Property)BlockStateProperties.field_208152_E, state.func_177229_b((Property)BlockStateProperties.field_208151_D))).func_206870_a((Property)BlockStateProperties.field_208153_F, state.func_177229_b((Property)BlockStateProperties.field_208152_E))).func_206870_a((Property)BlockStateProperties.field_208154_G, state.func_177229_b((Property)BlockStateProperties.field_208153_F));
            }
        }
        return state;
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208151_D, state.func_177229_b((Property)BlockStateProperties.field_208153_F))).func_206870_a((Property)BlockStateProperties.field_208153_F, state.func_177229_b((Property)BlockStateProperties.field_208151_D));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208152_E, state.func_177229_b((Property)BlockStateProperties.field_208154_G))).func_206870_a((Property)BlockStateProperties.field_208154_G, state.func_177229_b((Property)BlockStateProperties.field_208152_E));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    private static boolean facingConnected(Direction facing, BlockState state, DirectionProperty property) {
        return !state.func_235901_b_((Property)property) || state.func_177229_b((Property)property) == facing;
    }

    protected boolean isConnected(Direction facing, BlockState facingState) {
        if (!facingState.func_235714_a_(CeramicsTags.Blocks.CISTERN_CONNECTIONS)) {
            return false;
        }
        Direction opposite = facing.func_176734_d();
        BooleanProperty sideProp = CONNECTIONS.get(opposite);
        if (facingState.func_235901_b_((Property)sideProp)) {
            return (Boolean)facingState.func_177229_b((Property)sideProp);
        }
        EnumProperty<ChannelBlock.ChannelConnection> channelProp = ChannelBlock.DIRECTION_MAP.get(opposite);
        if (facingState.func_235901_b_(channelProp)) {
            return facingState.func_177229_b(channelProp) == ChannelBlock.ChannelConnection.OUT;
        }
        if (facingState.func_235901_b_((Property)BlockStateProperties.field_208158_K) && facingState.func_177229_b((Property)BlockStateProperties.field_208158_K) != AttachFace.WALL) {
            return false;
        }
        return CisternBlock.facingConnected(facing, facingState, BlockStateProperties.field_208157_J) && CisternBlock.facingConnected(facing, facingState, BlockStateProperties.field_208155_H) && CisternBlock.facingConnected(facing, facingState, BlockStateProperties.field_208156_I);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)EXTENSION, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this)))).func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(this.isConnected(Direction.NORTH, world.func_180495_p(pos.func_177978_c()))))).func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(this.isConnected(Direction.SOUTH, world.func_180495_p(pos.func_177968_d()))))).func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(this.isConnected(Direction.WEST, world.func_180495_p(pos.func_177976_e()))))).func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(this.isConnected(Direction.EAST, world.func_180495_p(pos.func_177974_f()))));
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!facing.func_176740_k().func_200128_b()) {
            state = (BlockState)state.func_206870_a((Property)CONNECTIONS.get(facing), (Comparable)Boolean.valueOf(this.isConnected(facing, facingState)));
        } else if (facing == Direction.DOWN) {
            state = (BlockState)state.func_206870_a((Property)EXTENSION, (Comparable)Boolean.valueOf(facingState.func_203425_a((Block)this)));
        }
        return state;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape[] boundList = (Boolean)state.func_177229_b((Property)EXTENSION) != false ? BOUNDS_EXTENSION : BOUNDS_BASE;
        return boundList[CisternBlock.boundsKey((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D), (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F), (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G), (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E))];
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)EXTENSION) != false ? SOLIDNESS_EXTENSION : SOLIDNESS_BASE;
    }

    static {
        SOLIDNESS_BASE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)CisternBlock.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        SOLIDNESS_EXTENSION = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)CisternBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        BOUNDS_BASE = CisternBlock.makeBounds(VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_216384_a((VoxelShape)CisternBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), (VoxelShape[])new VoxelShape[]{CisternBlock.func_208617_a((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0), CisternBlock.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0)}), (VoxelShape)CisternBlock.func_208617_a((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
        BOUNDS_EXTENSION = CisternBlock.makeBounds(VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)CisternBlock.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0), (VoxelShape)CisternBlock.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0)), (VoxelShape)CisternBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
    }
}

