/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.blocks.ChannelBlock;
import knightminer.ceramics.tileentity.ChannelTileEntity;
import knightminer.ceramics.tileentity.CrackableTileEntityHandler;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import slimeknights.mantle.util.TileEntityHelper;

public class FlowingChannelBlock
extends ChannelBlock
implements CrackableTileEntityHandler.ICrackableBlock {
    private final boolean crackable;

    public FlowingChannelBlock(AbstractBlock.Properties props, boolean crackable) {
        super(props);
        this.crackable = crackable;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ChannelTileEntity(this.crackable);
    }

    private static Direction fromOffset(BlockPos pos, BlockPos neighbor) {
        BlockPos offset = neighbor.func_177973_b((Vector3i)pos);
        for (Direction direction : Direction.values()) {
            if (!direction.func_176730_m().equals((Object)offset)) continue;
            return direction;
        }
        Ceramics.LOG.error("Channel found no offset for position pair {} and {} on neighbor changed", (Object)pos, (Object)neighbor);
        return Direction.DOWN;
    }

    @Override
    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.func_201670_d()) {
            TileEntityHelper.getTile(ChannelTileEntity.class, (IBlockReader)worldIn, (BlockPos)pos).ifPresent(te -> te.removeCachedNeighbor(FlowingChannelBlock.fromOffset(pos, fromPos)));
        }
    }

    @Override
    protected void activateTileEntity(BlockState state, World world, BlockPos pos, Direction side) {
        TileEntityHelper.getTile(ChannelTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> te.refreshNeighbor(state, side));
    }

    @Override
    public boolean isCrackable() {
        return this.crackable;
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.isCrackable()) {
            TileEntityHelper.getTile(ChannelTileEntity.class, (IBlockReader)worldIn, (BlockPos)pos).ifPresent(ChannelTileEntity::randomTick);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.crackable) {
            CrackableTileEntityHandler.ICrackableBlock.onBlockPlacedBy((IWorld)worldIn, pos, stack);
        }
    }

    @Override
    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.crackable && CrackableTileEntityHandler.ICrackableBlock.tryRepair((IWorld)world, pos, player, hand)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }
}

