/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import knightminer.ceramics.blocks.CisternBlock;
import knightminer.ceramics.tileentity.CisternTileEntity;
import knightminer.ceramics.tileentity.CrackableTileEntityHandler;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.util.TileEntityHelper;

public class FluidCisternBlock
extends CisternBlock
implements CrackableTileEntityHandler.ICrackableBlock {
    private final boolean crackable;

    public FluidCisternBlock(AbstractBlock.Properties properties, boolean crackable) {
        super(properties);
        this.crackable = crackable;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CisternTileEntity(this.crackable);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.crackable && CrackableTileEntityHandler.ICrackableBlock.tryRepair((IWorld)world, pos, player, hand)) {
            return ActionResultType.SUCCESS;
        }
        if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)).isPresent()) {
            TileEntity te;
            if (!world.func_201670_d() && (te = world.func_175625_s(pos)) != null) {
                te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).ifPresent(handler -> FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)handler));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private Optional<CisternTileEntity> findBase(World world, BlockPos pos) {
        BlockState checkState;
        BlockPos base = pos;
        while ((checkState = world.func_180495_p(base = base.func_177977_b())).func_203425_a((Block)this) && ((Boolean)checkState.func_177229_b((Property)CisternBlock.EXTENSION)).booleanValue()) {
        }
        if (checkState.func_203425_a((Block)this)) {
            return TileEntityHelper.getTile(CisternTileEntity.class, (IBlockReader)world, (BlockPos)base);
        }
        return Optional.empty();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (((Boolean)state.func_177229_b((Property)CisternBlock.EXTENSION)).booleanValue()) {
            this.findBase(world, pos).ifPresent(te -> te.addExtension(pos));
            if (this.crackable) {
                CrackableTileEntityHandler.ICrackableBlock.onBlockPlacedBy((IWorld)world, pos, stack);
            }
        } else {
            TileEntityHelper.getTile(CisternTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> {
                te.tryMerge(pos.func_177984_a());
                if (this.crackable) {
                    te.getCracksHandler().setCracks(stack);
                }
            });
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
            if (((Boolean)state.func_177229_b((Property)EXTENSION)).booleanValue()) {
                this.findBase(world, pos).ifPresent(te -> te.removeExtension(pos));
            } else {
                TileEntityHelper.getTile(CisternTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> te.onBroken(this));
            }
            world.func_175713_t(pos);
        }
    }

    @Override
    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!facing.func_176740_k().func_200128_b()) {
            state = (BlockState)state.func_206870_a((Property)CONNECTIONS.get(facing), (Comparable)Boolean.valueOf(this.isConnected(facing, facingState)));
        }
        return state;
    }

    @Override
    public boolean isCrackable() {
        return this.crackable;
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.isCrackable() && random.nextInt(5) == 0) {
            TileEntityHelper.getTile(CisternTileEntity.class, (IBlockReader)worldIn, (BlockPos)pos).ifPresent(CisternTileEntity::randomTick);
        }
    }
}

