/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import knightminer.ceramics.blocks.FaucetBlock;
import knightminer.ceramics.tileentity.CrackableTileEntityHandler;
import knightminer.ceramics.tileentity.FaucetTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.util.TileEntityHelper;

public class PouringFaucetBlock
extends FaucetBlock
implements CrackableTileEntityHandler.ICrackableBlock {
    private final boolean crackable;

    public PouringFaucetBlock(AbstractBlock.Properties builder, boolean crackable) {
        super(builder);
        this.crackable = crackable;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FaucetTileEntity(this.crackable);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.isCrackable() && CrackableTileEntityHandler.ICrackableBlock.tryRepair((IWorld)worldIn, pos, player, handIn)) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        this.getFaucet(worldIn, pos).ifPresent(FaucetTileEntity::activate);
        return ActionResultType.SUCCESS;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.func_201670_d()) {
            return;
        }
        this.getFaucet(worldIn, pos).ifPresent(faucet -> {
            faucet.neighborChanged(fromPos);
            faucet.handleRedstone(worldIn.func_175640_z(pos));
        });
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.getFaucet((World)worldIn, pos).ifPresent(FaucetTileEntity::activate);
    }

    private Optional<FaucetTileEntity> getFaucet(World world, BlockPos pos) {
        return TileEntityHelper.getTile(FaucetTileEntity.class, (IBlockReader)world, (BlockPos)pos);
    }

    private static void addParticles(BlockState state, IWorld worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        double x = (double)pos.func_177958_n() + 0.5 - 0.3 * (double)direction.func_82601_c();
        double y = (double)pos.func_177956_o() + 0.5 - 0.3 * (double)direction.func_96559_d();
        double z = (double)pos.func_177952_p() + 0.5 - 0.3 * (double)direction.func_82599_e();
        worldIn.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, 0.5f), x, y, z, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.getFaucet(worldIn, pos).ifPresent(faucet -> {
            if (faucet.isPouring() && faucet.getRenderFluid().isEmpty() && rand.nextFloat() < 0.25f) {
                PouringFaucetBlock.addParticles(stateIn, (IWorld)worldIn, pos);
            }
        });
    }

    @Override
    public boolean isCrackable() {
        return this.crackable;
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.isCrackable()) {
            TileEntityHelper.getTile(FaucetTileEntity.class, (IBlockReader)worldIn, (BlockPos)pos).ifPresent(FaucetTileEntity::randomTick);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.isCrackable()) {
            CrackableTileEntityHandler.ICrackableBlock.onBlockPlacedBy((IWorld)worldIn, pos, stack);
        }
    }
}

