/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import knightminer.ceramics.client.model.CrackedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class CisternModel
implements IModelGeometry<CisternModel> {
    public static final Loader<CisternModel> LOADER = new Loader<CisternModel>(CisternModel::new);
    public static final Loader<CrackedModel> CRACKED_LOADER = new Loader<CrackedModel>(Cracked::new);
    private final SimpleBlockModel model;
    private final Map<Direction, FluidCuboid> fluids;

    public CisternModel(SimpleBlockModel model, Map<Direction, FluidCuboid> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        IBakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new BakedModel(baked, this.fluids);
    }

    private static class Loader<T extends IModelGeometry<T>>
    implements IModelLoader<T> {
        private final BiFunction<SimpleBlockModel, Map<Direction, FluidCuboid>, T> constructor;

        public Loader(BiFunction<SimpleBlockModel, Map<Direction, FluidCuboid>, T> constructor) {
            this.constructor = constructor;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public T read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
            JsonObject fluidJson = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"fluids");
            EnumMap<Direction, FluidCuboid> fluids = new EnumMap<Direction, FluidCuboid>(Direction.class);
            fluids.put(Direction.DOWN, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)fluidJson, (String)"base")));
            fluids.put(Direction.UP, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)fluidJson, (String)"extension")));
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!fluidJson.has(direction.func_176610_l())) continue;
                fluids.put(direction, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)fluidJson, (String)direction.func_176610_l())));
            }
            return (T)((IModelGeometry)this.constructor.apply(model, fluids));
        }
    }

    public static class BakedModel
    extends BakedModelWrapper<IBakedModel> {
        private final Map<Direction, FluidCuboid> fluids;

        private BakedModel(IBakedModel originalModel, Map<Direction, FluidCuboid> fluids) {
            super(originalModel);
            this.fluids = fluids;
        }

        public FluidCuboid getCenterFluid(boolean extension) {
            return this.fluids.get(extension ? Direction.UP : Direction.DOWN);
        }

        @Nullable
        public FluidCuboid getFluid(Direction direction) {
            return this.fluids.get(direction);
        }
    }

    private static class Cracked
    extends CrackedModel {
        private final Map<Direction, FluidCuboid> fluids;

        public Cracked(SimpleBlockModel model, Map<Direction, FluidCuboid> fluids) {
            super(model);
            this.fluids = fluids;
        }

        @Override
        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            IBakedModel model = super.bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
            return new BakedModel(model, this.fluids);
        }
    }
}

