/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import knightminer.ceramics.items.CrackableBlockItem;
import knightminer.ceramics.tileentity.CrackableTileEntityHandler;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ExtraTextureConfiguration;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class CrackedModel
implements IModelGeometry<CrackedModel> {
    public static final ItemOverrideList OVERRIDES = new ItemOverrideList(){

        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
            int cracks = CrackableBlockItem.getCracks(stack);
            if (cracks > 0 && model instanceof BakedModel) {
                return ((BakedModel)model).getModel(cracks);
            }
            return model;
        }
    };
    public static final IModelLoader<CrackedModel> LOADER = new Loader();
    private final SimpleBlockModel model;

    public CrackedModel(SimpleBlockModel model) {
        this.model = model;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        Collection textures = this.model.getTextures(owner, modelGetter, missingTextureErrors);
        for (int i = 1; i <= 5; ++i) {
            String name = "cracks_" + i;
            RenderMaterial material = owner.resolveTexture(name);
            if (Objects.equals(material.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
                missingTextureErrors.add((Pair<String, String>)Pair.of((Object)name, (Object)owner.getModelName()));
            }
            textures.add(material);
        }
        return textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        RenderMaterial[] textures = new RenderMaterial[5];
        for (int i = 0; i < 5; ++i) {
            textures[i] = owner.resolveTexture("cracks_" + (i + 1));
        }
        List elements = this.model.getElements();
        ArrayList<BlockPart> newElements = new ArrayList<BlockPart>(elements.size() * 2);
        newElements.addAll(elements);
        for (BlockPart element : elements) {
            HashMap mapFaces = new HashMap();
            for (Map.Entry entry : element.field_178240_c.entrySet()) {
                BlockPartFace face = (BlockPartFace)entry.getValue();
                mapFaces.put(entry.getKey(), new BlockPartFace(face.field_178244_b, -1, "cracks", face.field_178243_e));
            }
            newElements.add(new BlockPart(element.field_178241_a, element.field_178239_b, mapFaces, element.field_178237_d, element.field_178238_e));
        }
        IBakedModel original = this.model.bakeModel(owner, transform, OVERRIDES, spriteGetter, location);
        return new BakedModel(original, owner, newElements, textures, transform);
    }

    private static class Loader
    implements IModelLoader<CrackedModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public CrackedModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new CrackedModel(SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)modelContents));
        }
    }

    private static class BakedModel
    extends DynamicBakedWrapper<IBakedModel> {
        private final IBakedModel[] crackedModels;
        private final IModelConfiguration owner;
        private final List<BlockPart> elements;
        private final RenderMaterial[] textures;
        private final IModelTransform transform;

        public BakedModel(IBakedModel originalModel, IModelConfiguration owner, List<BlockPart> elements, RenderMaterial[] textures, IModelTransform transform) {
            super(originalModel);
            this.crackedModels = new IBakedModel[textures.length];
            this.owner = owner;
            this.elements = elements;
            this.textures = textures;
            this.transform = transform;
        }

        public IBakedModel getModel(int cracks) {
            int stage = cracks - 1;
            if (this.crackedModels[stage] == null) {
                ExtraTextureConfiguration retextured = new ExtraTextureConfiguration(this.owner, (Map)ImmutableMap.of((Object)"cracks", (Object)this.textures[stage]));
                this.crackedModels[stage] = SimpleBlockModel.bakeDynamic((IModelConfiguration)retextured, this.elements, (IModelTransform)this.transform);
            }
            return this.crackedModels[stage];
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random random, IModelData data) {
            Integer cracks = (Integer)data.getData(CrackableTileEntityHandler.PROPERTY);
            if (cracks != null && cracks > 0) {
                return this.getModel(cracks).getQuads(state, side, random, data);
            }
            return this.originalModel.getQuads(state, side, random, data);
        }
    }
}

