/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import knightminer.ceramics.blocks.CisternBlock;
import knightminer.ceramics.client.model.CisternModel;
import knightminer.ceramics.tileentity.CisternTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.render.FluidRenderer;

public class CisternTileEntityRenderer
extends TileEntityRenderer<CisternTileEntity> {
    public CisternTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(CisternTileEntity tileEntity, float partialTicks, MatrixStack matrices, IRenderTypeBuffer buffer, int light, int combinedOverlay) {
        block6: {
            BlockState state;
            CisternModel.BakedModel model;
            FluidStack fluid = ((IFluidHandler)tileEntity.getPublicHandler().orElse((Object)EmptyFluidHandler.INSTANCE)).getFluidInTank(0);
            if (fluid.isEmpty()) break block6;
            int renderIndex = tileEntity.getRenderIndex();
            int amount = fluid.getAmount() - tileEntity.capacityFor(renderIndex);
            if (amount > 0 && (model = (CisternModel.BakedModel)ModelHelper.getBakedModel((BlockState)(state = tileEntity.func_195044_w()), CisternModel.BakedModel.class)) != null) {
                FluidAttributes attributes = fluid.getFluid().getAttributes();
                TextureAtlasSprite still = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getStillTexture(fluid));
                TextureAtlasSprite flowing = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getFlowingTexture(fluid));
                IVertexBuilder builder = buffer.getBuffer(FluidRenderer.RENDER_TYPE);
                int color = attributes.getColor(fluid);
                light = FluidRenderer.withBlockLight((int)light, (int)attributes.getLuminosity(fluid));
                int capacityPerLayer = tileEntity.capacityPerLayer();
                if (amount > capacityPerLayer) {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        FluidCuboid cuboid = model.getFluid(direction);
                        if (cuboid == null || !((Boolean)state.func_177229_b((Property)CisternBlock.CONNECTIONS.get(direction))).booleanValue()) continue;
                        FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)builder, (FluidCuboid)cuboid, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (Vector3f)cuboid.getFromScaled(), (Vector3f)cuboid.getToScaled(), (int)color, (int)light, (boolean)false);
                    }
                } else {
                    FluidCuboid center = model.getCenterFluid((Boolean)state.func_177229_b((Property)CisternBlock.EXTENSION));
                    Vector3f from = center.getFromScaled();
                    Vector3f to = center.getToScaled().func_229195_e_();
                    float minY = from.func_195900_b();
                    to.setY(minY + (float)amount * (to.func_195900_b() - minY) / (float)capacityPerLayer);
                    FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)builder, (FluidCuboid)center, (TextureAtlasSprite)still, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (int)color, (int)light, (boolean)false);
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        Vector3f sFrom;
                        FluidCuboid cuboid = model.getFluid(direction);
                        if (cuboid == null || !((Boolean)state.func_177229_b((Property)CisternBlock.CONNECTIONS.get(direction))).booleanValue() || !((sFrom = cuboid.getFromScaled()).func_195900_b() < to.func_195900_b())) continue;
                        Vector3f sTo = cuboid.getToScaled();
                        if (sTo.func_195900_b() > to.func_195900_b()) {
                            sTo = sTo.func_229195_e_();
                            sTo.setY(to.func_195900_b());
                        }
                        FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)builder, (FluidCuboid)cuboid, (TextureAtlasSprite)still, (TextureAtlasSprite)still, (Vector3f)sFrom, (Vector3f)sTo, (int)color, (int)light, (boolean)false);
                    }
                }
            }
        }
    }
}

