/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.datagen;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import knightminer.ceramics.Registration;
import net.minecraft.block.Block;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;

public class BlockLootTables
extends net.minecraft.data.loot.BlockLootTables {
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "ceramics".equals(Objects.requireNonNull(block.getRegistryName()).func_110624_b())).collect(Collectors.toList());
    }

    protected void addTables() {
        IntFunction<Function> dropClay = count -> block -> BlockLootTables.func_218530_a((Block)block, (IItemProvider)Items.field_151119_aD, (IRandomRange)ConstantRange.func_215835_a((int)count));
        IntFunction<Function> dropPorcelain = count -> block -> BlockLootTables.func_218530_a((Block)block, Registration.UNFIRED_PORCELAIN, (IRandomRange)ConstantRange.func_215835_a((int)count));
        Function<Block, LootTable.Builder> dropSelfWithCracks = block -> BlockLootTables.func_218546_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216055_a("cracks", "cracks", CopyNbt.Action.REPLACE));
        this.func_218522_a((Block)Registration.UNFIRED_PORCELAIN_BLOCK.get(), dropPorcelain.apply(4));
        Registration.PORCELAIN_BLOCK.forEach(arg_0 -> ((BlockLootTables)this).func_218492_c(arg_0));
        Registration.RAINBOW_PORCELAIN.forEach(arg_0 -> ((BlockLootTables)this).func_218492_c(arg_0));
        this.registerBuildingLootTable(Registration.DARK_BRICKS);
        this.registerBuildingLootTable(Registration.LAVA_BRICKS);
        this.registerBuildingLootTable(Registration.DRAGON_BRICKS);
        this.registerBuildingLootTable(Registration.PORCELAIN_BRICKS);
        this.registerBuildingLootTable(Registration.MONOCHROME_BRICKS);
        this.registerBuildingLootTable(Registration.GOLDEN_BRICKS);
        this.registerBuildingLootTable(Registration.MARINE_BRICKS);
        this.registerBuildingLootTable(Registration.RAINBOW_BRICKS);
        this.func_218492_c((Block)Registration.KILN.get());
        this.func_218492_c((Block)Registration.TERRACOTTA_GAUGE.get());
        this.func_218492_c((Block)Registration.PORCELAIN_GAUGE.get());
        this.func_218522_a((Block)Registration.CLAY_CISTERN.get(), dropClay.apply(3));
        this.func_218522_a((Block)Registration.UNFIRED_CISTERN.get(), dropPorcelain.apply(3));
        this.func_218522_a((Block)Registration.TERRACOTTA_CISTERN.get(), dropSelfWithCracks);
        Registration.COLORED_CISTERN.forEach(cistern -> this.func_218522_a((Block)cistern, dropSelfWithCracks));
        Registration.PORCELAIN_CISTERN.forEach(arg_0 -> ((BlockLootTables)this).func_218492_c(arg_0));
        this.func_218522_a((Block)Registration.CLAY_FAUCET.get(), dropClay.apply(2));
        this.func_218522_a((Block)Registration.UNFIRED_FAUCET.get(), dropPorcelain.apply(2));
        this.func_218522_a((Block)Registration.TERRACOTTA_FAUCET.get(), dropSelfWithCracks);
        this.func_218492_c((Block)Registration.PORCELAIN_FAUCET.get());
        this.func_218522_a((Block)Registration.CLAY_CHANNEL.get(), dropClay.apply(2));
        this.func_218522_a((Block)Registration.UNFIRED_CHANNEL.get(), dropPorcelain.apply(2));
        this.func_218522_a((Block)Registration.TERRACOTTA_CHANNEL.get(), dropSelfWithCracks);
        this.func_218492_c((Block)Registration.PORCELAIN_CHANNEL.get());
    }

    private void registerBuildingLootTable(WallBuildingBlockObject building) {
        this.func_218492_c((Block)building.get());
        this.func_218522_a((Block)building.getSlab(), net.minecraft.data.loot.BlockLootTables::func_218513_d);
        this.func_218492_c((Block)building.getStairs());
        this.func_218492_c((Block)building.getWall());
    }
}

