/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.items;

import java.util.List;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.items.FixedTooltipBlockItem;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrackableBlockItem
extends FixedTooltipBlockItem {
    private static final String TOOLTIP_KEY = Ceramics.lang("tooltip", "cracked");

    public CrackableBlockItem(Block blockIn, Item.Properties builder, String tooltipSuffix) {
        super(blockIn, builder, tooltipSuffix);
    }

    public static int getCracks(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("cracks", 99)) {
            return nbt.func_74762_e("cracks");
        }
        return 0;
    }

    public static ItemStack setCracks(ItemStack stack, int cracks) {
        if (cracks == 0) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null) {
                nbt.func_82580_o("cracks");
                if (nbt.isEmpty()) {
                    stack.func_77982_d(null);
                }
            }
        } else {
            stack.func_196082_o().func_74768_a("cracks", cracks);
        }
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, worldIn, tooltip, flag);
        int cracks = CrackableBlockItem.getCracks(stack);
        if (cracks > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent(TOOLTIP_KEY, new Object[]{6 - cracks, 6}));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_190916_E() == 1 && CrackableBlockItem.getCracks(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)CrackableBlockItem.getCracks(stack) / 6.0;
    }
}

