/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.network.ChannelFlowPacket;
import knightminer.ceramics.network.ChannelFluidUpdatePacket;
import knightminer.ceramics.network.CisternUpdatePacket;
import knightminer.ceramics.network.CrackableCrackPacket;
import knightminer.ceramics.network.FaucetActivationPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import slimeknights.mantle.network.NetworkWrapper;

public class CeramicsNetwork
extends NetworkWrapper {
    private static CeramicsNetwork INSTANCE;

    private CeramicsNetwork() {
        super(Ceramics.getResource("network"));
    }

    public static CeramicsNetwork getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Attempt to get network instance before initialization");
        }
        return INSTANCE;
    }

    public static void init() {
        if (INSTANCE == null) {
            INSTANCE = new CeramicsNetwork();
            INSTANCE.registerPacket(CisternUpdatePacket.class, CisternUpdatePacket::new, NetworkDirection.PLAY_TO_CLIENT);
            INSTANCE.registerPacket(FaucetActivationPacket.class, FaucetActivationPacket::new, NetworkDirection.PLAY_TO_CLIENT);
            INSTANCE.registerPacket(ChannelFluidUpdatePacket.class, ChannelFluidUpdatePacket::new, NetworkDirection.PLAY_TO_CLIENT);
            INSTANCE.registerPacket(ChannelFlowPacket.class, ChannelFlowPacket::new, NetworkDirection.PLAY_TO_CLIENT);
            INSTANCE.registerPacket(CrackableCrackPacket.class, CrackableCrackPacket::new, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void sendToClientsAround(Object msg, @Nullable World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            this.sendToClientsAround(msg, (ServerWorld)world, pos);
        }
    }
}

