/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import knightminer.ceramics.tileentity.CisternTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.TileEntityHelper;

public class CisternUpdatePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final FluidStack fluid;
    private final boolean shouldRefreshCapabilities;

    public CisternUpdatePacket(BlockPos pos, FluidStack fluid, boolean shouldRefreshCapabilities) {
        this.pos = pos;
        this.fluid = fluid;
        this.shouldRefreshCapabilities = shouldRefreshCapabilities;
    }

    public CisternUpdatePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.fluid = FluidStack.readFromPacket((PacketBuffer)buffer);
        this.shouldRefreshCapabilities = buffer.readBoolean();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        this.fluid.writeToPacket(buffer);
        buffer.writeBoolean(this.shouldRefreshCapabilities);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(CisternUpdatePacket packet) {
            TileEntityHelper.getTile(CisternTileEntity.class, (IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)packet.pos).ifPresent(te -> te.updateFluidTo(packet.fluid, packet.shouldRefreshCapabilities));
        }
    }
}

