/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.plugin.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.Registration;
import knightminer.ceramics.client.gui.KilnScreen;
import knightminer.ceramics.container.KilnContainer;
import knightminer.ceramics.items.BaseClayBucketItem;
import knightminer.ceramics.items.ClayBucketItem;
import knightminer.ceramics.items.CrackableBlockItem;
import knightminer.ceramics.plugin.jei.KilnCategory;
import knightminer.ceramics.recipe.CeramicsTags;
import knightminer.ceramics.recipe.KilnRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ceramics", "jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ISubtypeInterpreter bucketInterpreter = BaseClayBucketItem::getSubtype;
        registration.registerSubtypeInterpreter((Item)Registration.CLAY_BUCKET.get(), bucketInterpreter);
        registration.registerSubtypeInterpreter((Item)Registration.CRACKED_CLAY_BUCKET.get(), bucketInterpreter);
        ISubtypeInterpreter crackableClay = stack -> CrackableBlockItem.getCracks(stack) > 0 ? "cracked" : "";
        registration.registerSubtypeInterpreter(Registration.TERRACOTTA_CISTERN.func_199767_j(), crackableClay);
        Registration.COLORED_CISTERN.forEach(block -> registration.registerSubtypeInterpreter(block.func_199767_j(), crackableClay));
        registration.registerSubtypeInterpreter(Registration.TERRACOTTA_FAUCET.func_199767_j(), crackableClay);
        registration.registerSubtypeInterpreter(Registration.TERRACOTTA_CHANNEL.func_199767_j(), crackableClay);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new KilnCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        assert (world != null);
        RecipeManager recipeManager = world.func_199532_z();
        ArrayList<KilnRecipe> results = new ArrayList<KilnRecipe>();
        for (IRecipe recipe : recipeManager.func_215366_a(Registration.KILN_RECIPE).values()) {
            if (recipe.func_192399_d()) continue;
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b()) {
                Ceramics.LOG.error("Invalid kiln recipe {}, no output", (Object)recipe.func_199560_c());
                continue;
            }
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients.size() != 1) {
                Ceramics.LOG.error("Invalid kiln recipe {}, wrong number of inputs", (Object)recipe.func_199560_c());
                continue;
            }
            if (!(recipe instanceof KilnRecipe)) {
                Ceramics.LOG.error("Invalid kiln recipe {}, wrong class", (Object)recipe.func_199560_c());
                continue;
            }
            results.add((KilnRecipe)recipe);
        }
        registration.addRecipes(results, KilnCategory.UID);
        List clayRepair = CeramicsTags.Items.TERRACOTTA_CRACK_REPAIR.func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList());
        registration.addIngredientInfo(clayRepair, VanillaTypes.ITEM, new String[]{Ceramics.lang("jei", "clay_repair")});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(KilnScreen.class, 78, 32, 28, 23, new ResourceLocation[]{KilnCategory.UID, VanillaRecipeCategoryUid.FUEL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(KilnContainer.class, KilnCategory.UID, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(KilnContainer.class, VanillaRecipeCategoryUid.FUEL, 1, 1, 3, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack(Registration.KILN), new ResourceLocation[]{KilnCategory.UID, VanillaRecipeCategoryUid.FUEL});
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        NonNullList buckets = NonNullList.func_191196_a();
        ((ClayBucketItem)Registration.CLAY_BUCKET.get()).func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)buckets);
        ((ClayBucketItem)Registration.CRACKED_CLAY_BUCKET.get()).func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)buckets);
        runtime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)buckets);
    }
}

