/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.recipe;

import java.util.function.Consumer;
import knightminer.ceramics.Ceramics;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TagsUpdatedEvent;

public class CeramicsTags {
    private static boolean tagsLoaded = false;

    public static void init() {
        Blocks.init();
        Items.init();
        Fluids.init();
        Consumer<TagsUpdatedEvent.VanillaTagTypes> onTagsLoaded = event -> {
            tagsLoaded = true;
        };
        MinecraftForge.EVENT_BUS.addListener(onTagsLoaded);
    }

    public static boolean tagsLoaded() {
        return tagsLoaded;
    }

    public static class Fluids {
        public static final Tags.IOptionalNamedTag<Fluid> HOT_FLUIDS = Fluids.makeWrapperTag("hot_fluids");
        public static final Tags.IOptionalNamedTag<Fluid> COOL_FLUIDS = Fluids.makeWrapperTag("cool_fluids");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<Fluid> makeWrapperTag(String id) {
            return FluidTags.createOptional((ResourceLocation)Ceramics.getResource(id));
        }
    }

    public static class Items {
        public static final Tags.IOptionalNamedTag<Item> COLORED_TERRACOTTA = Items.ceramicsTag("colored_terracotta");
        public static final Tags.IOptionalNamedTag<Item> PORCELAIN = Items.ceramicsTag("porcelain_block");
        public static final Tags.IOptionalNamedTag<Item> COLORED_PORCELAIN = Items.ceramicsTag("colored_porcelain");
        public static final Tags.IOptionalNamedTag<Item> RAINBOW_PORCELAIN = Items.ceramicsTag("rainbow_porcelain");
        public static final Tags.IOptionalNamedTag<Item> BRICKS = Items.ceramicsTag("bricks");
        public static final Tags.IOptionalNamedTag<Item> MILK_BUCKETS = Items.forgeTag("buckets/milk");
        public static final Tags.IOptionalNamedTag<Item> TERRACOTTA_CISTERNS = Items.ceramicsTag("terracotta_cisterns");
        public static final Tags.IOptionalNamedTag<Item> PORCELAIN_CISTERNS = Items.ceramicsTag("porcelain_cisterns");
        public static final Tags.IOptionalNamedTag<Item> TERRACOTTA_CRACK_REPAIR = Items.ceramicsTag("terracotta_crack_repair");
        public static final Tags.IOptionalNamedTag<Item> PLATES = Items.forgeTag("plates");
        public static final Tags.IOptionalNamedTag<Item> BRICK_PLATES = Items.forgeTag("plates/brick");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<Item> ceramicsTag(String id) {
            return ItemTags.createOptional((ResourceLocation)Ceramics.getResource(id));
        }

        private static Tags.IOptionalNamedTag<Item> forgeTag(String id) {
            return ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", id));
        }
    }

    public static class Blocks {
        public static final Tags.IOptionalNamedTag<Block> COLORED_TERRACOTTA = Blocks.ceramicsTag("colored_terracotta");
        public static final Tags.IOptionalNamedTag<Block> PORCELAIN = Blocks.ceramicsTag("porcelain_block");
        public static final Tags.IOptionalNamedTag<Block> COLORED_PORCELAIN = Blocks.ceramicsTag("colored_porcelain");
        public static final Tags.IOptionalNamedTag<Block> RAINBOW_PORCELAIN = Blocks.ceramicsTag("rainbow_porcelain");
        public static final Tags.IOptionalNamedTag<Block> BRICKS = Blocks.ceramicsTag("bricks");
        public static final Tags.IOptionalNamedTag<Block> TERRACOTTA_CISTERNS = Blocks.ceramicsTag("terracotta_cisterns");
        public static final Tags.IOptionalNamedTag<Block> PORCELAIN_CISTERNS = Blocks.ceramicsTag("porcelain_cisterns");
        public static final Tags.IOptionalNamedTag<Block> CISTERN_CONNECTIONS = Blocks.ceramicsTag("cistern_connections");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<Block> ceramicsTag(String id) {
            return BlockTags.createOptional((ResourceLocation)Ceramics.getResource(id));
        }
    }
}

