/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.Registration;
import knightminer.ceramics.items.CrackableBlockItem;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;

public class CrackedClayRepairRecipe
extends ShapelessRecipe {
    private final Item item;
    private final Ingredient repairIngredient;

    public CrackedClayRepairRecipe(ResourceLocation id, IItemProvider item, Ingredient repairIngredient) {
        super(id, Ceramics.locationName("clay_repair"), new ItemStack(item), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{CrackableBlockItem.setCracks(new ItemStack(item), 3)}), repairIngredient}));
        this.item = item.func_199767_j();
        this.repairIngredient = repairIngredient;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!super.func_77569_a(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != this.item) continue;
            return CrackableBlockItem.getCracks(stack) > 0;
        }
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != this.item) continue;
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            return CrackableBlockItem.setCracks(stack, Math.max(0, CrackableBlockItem.getCracks(stack) - 3));
        }
        return super.func_77572_b(inv);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Registration.CLAY_REPAIR_RECIPE_SERIALIZER.get();
    }

    public static class FinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item item;
        private final Ingredient ingredient;
        @Nullable
        private final Advancement.Builder advancementBuilder;
        @Nullable
        private final ResourceLocation advancementId;

        public FinishedRecipe(ResourceLocation id, IItemProvider item, Ingredient ingredient, @Nullable ICriterionInstance criteria) {
            this.id = id;
            this.item = item.func_199767_j();
            this.ingredient = ingredient;
            if (criteria != null) {
                this.advancementBuilder = Advancement.Builder.func_200278_a().func_200275_a("has_item", criteria).func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
                this.advancementId = new ResourceLocation(id.func_110624_b(), "recipes/clay_repair/" + id.func_110623_a());
            } else {
                this.advancementBuilder = null;
                this.advancementId = null;
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("item", Objects.requireNonNull(this.item.getRegistryName()).toString());
            json.add("ingredient", this.ingredient.func_200304_c());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)Registration.CLAY_REPAIR_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            if (this.advancementBuilder != null) {
                return this.advancementBuilder.func_200273_b();
            }
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrackedClayRepairRecipe> {
        public CrackedClayRepairRecipe read(ResourceLocation id, JsonObject json) {
            Item item = (Item)RecipeHelper.deserializeItem((String)JSONUtils.func_151200_h((JsonObject)json, (String)"item"), (String)"item", Item.class);
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            return new CrackedClayRepairRecipe(id, (IItemProvider)item, ingredient);
        }

        public CrackedClayRepairRecipe read(ResourceLocation id, PacketBuffer buffer) {
            Item item = RecipeHelper.readItem((PacketBuffer)buffer);
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new CrackedClayRepairRecipe(id, (IItemProvider)item, ingredient);
        }

        public void write(PacketBuffer buffer, CrackedClayRepairRecipe recipe) {
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.item);
            recipe.repairIngredient.func_199564_a(buffer);
        }
    }
}

