/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;

public class NoNBTIngredient
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();

    public NoNBTIngredient(Ingredient ingredient) {
        this(Arrays.stream(ingredient.field_199807_b));
    }

    protected NoNBTIngredient(Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && !stack.func_77942_o() && super.test(stack);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement func_200304_c() {
        JsonElement element = super.func_200304_c();
        if (!element.isJsonObject()) {
            throw new IllegalStateException("Invalid NoNBTIngredient");
        }
        JsonObject object = element.getAsJsonObject();
        object.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)SERIALIZER)).toString());
        return object;
    }

    private static class Serializer
    extends VanillaIngredientSerializer {
        private Serializer() {
        }

        public NoNBTIngredient parse(PacketBuffer buffer) {
            return new NoNBTIngredient(super.parse(buffer));
        }

        public Ingredient parse(JsonObject json) {
            return new NoNBTIngredient(super.parse(json));
        }
    }
}

