/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.tileentity;

import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.Registration;
import knightminer.ceramics.blocks.CisternBlock;
import knightminer.ceramics.items.BaseClayBucketItem;
import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.network.CisternUpdatePacket;
import knightminer.ceramics.tileentity.CrackableTileEntityHandler;
import knightminer.ceramics.util.tank.CisternTank;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.mantle.util.WeakConsumerWrapper;

public class CisternTileEntity
extends MantleTileEntity
implements CrackableTileEntityHandler.ICrackableTileEntity {
    private static final String TAG_FLUID = "fluid";
    private static final String TAG_EXTENSIONS = "extensions";
    private final CisternTank tank = new CisternTank(this);
    private int extensions = 0;
    @Nullable
    private LazyOptional<IFluidHandler> internalHandler;
    @Nullable
    private LazyOptional<IFluidHandler> publicHandler;
    private int renderIndex = 0;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> invalidationListener = new WeakConsumerWrapper((Object)this, (te, handler) -> te.invalidateHandlers());
    private final CrackableTileEntityHandler cracksHandler;

    public CisternTileEntity(boolean crackable) {
        super((TileEntityType)Registration.CISTERN_TILE_ENTITY.get());
        this.cracksHandler = new CrackableTileEntityHandler(this, crackable);
    }

    public CisternTileEntity() {
        this(false);
    }

    public int getExtensions() {
        return this.extensions;
    }

    public int getRenderIndex() {
        return this.renderIndex;
    }

    private void invalidateHandlers() {
        this.internalHandler = null;
        if (this.publicHandler != null) {
            this.publicHandler.invalidate();
            this.publicHandler = null;
        }
    }

    public int capacityPerLayer() {
        Block block = this.func_195044_w().func_177230_c();
        if (Registration.PORCELAIN_CISTERN.contains((IForgeRegistryEntry)block)) {
            return 6000;
        }
        return 4000;
    }

    public final int capacityFor(int height) {
        return height * this.capacityPerLayer();
    }

    @Override
    public CrackableTileEntityHandler getCracksHandler() {
        return this.cracksHandler;
    }

    public IModelData getModelData() {
        return this.cracksHandler.getModelData();
    }

    private void transferBaseTo(Block block, int index) {
        TileEntity te;
        assert (this.field_145850_b != null);
        BlockPos newBase = this.field_174879_c.func_177981_b(index);
        BlockState newState = this.field_145850_b.func_180495_p(newBase);
        if (newState.func_203425_a(block) && ((Boolean)newState.func_177229_b((Property)CisternBlock.EXTENSION)).booleanValue() && (te = this.field_145850_b.func_175625_s(newBase)) instanceof CisternTileEntity) {
            FluidStack fluid = FluidStack.EMPTY;
            int amountAboveRemoved = this.tank.getFluidAmount() - this.capacityFor(index);
            if (amountAboveRemoved > 0) {
                fluid = new FluidStack(this.tank.getFluid(), amountAboveRemoved);
            }
            ((CisternTileEntity)te).makeBase(fluid, this.extensions - index);
        }
    }

    public void onBroken(Block block) {
        if (this.extensions > 0) {
            this.transferBaseTo(block, 1);
        }
    }

    public void tryMerge(BlockPos checkPos) {
        assert (this.field_145850_b != null);
        if (this.field_145850_b.func_180495_p(checkPos).func_203425_a(this.func_195044_w().func_177230_c())) {
            TileEntityHelper.getTile(CisternTileEntity.class, (IBlockReader)this.field_145850_b, (BlockPos)checkPos).ifPresent(te -> te.makeExtension(this));
        }
    }

    public void addExtension(BlockPos extPos) {
        assert (this.field_145850_b != null);
        int newExtensions = extPos.func_177956_o() - this.field_174879_c.func_177956_o();
        if (newExtensions > this.extensions) {
            this.extensions = newExtensions;
            this.tryMerge(extPos.func_177984_a());
        }
    }

    public void removeExtension(BlockPos extPos) {
        assert (extPos.func_177956_o() > this.field_174879_c.func_177956_o());
        assert (this.field_145850_b != null);
        int removed = extPos.func_177956_o() - this.field_174879_c.func_177956_o();
        if (removed <= this.extensions) {
            if (removed < this.extensions) {
                this.transferBaseTo(this.func_195044_w().func_177230_c(), removed + 1);
            }
            this.extensions = removed - 1;
            this.tank.validateAmount();
        }
    }

    public void onFluidAdded(int amountAdded) {
        this.onTankChanged(false);
        FluidStack fluid = this.tank.getFluid();
        if (this.cracksHandler.isActive() && this.field_145850_b != null && !this.field_145850_b.func_201670_d() && BaseClayBucketItem.doesCrack(fluid.getFluid())) {
            int capacityPerLayer = this.capacityPerLayer();
            int startIndex = (fluid.getAmount() - amountAdded + capacityPerLayer - 1) / capacityPerLayer;
            int endIndex = (fluid.getAmount() - 1) / capacityPerLayer;
            for (int i = startIndex; i <= endIndex; ++i) {
                TileEntityHelper.getTile(CrackableTileEntityHandler.ICrackableTileEntity.class, (IBlockReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177981_b(i)).ifPresent(te -> te.getCracksHandler().fluidAdded(fluid));
            }
        }
    }

    protected LazyOptional<IFluidHandler> getInternalHandler() {
        if (this.internalHandler != null && this.publicHandler != null) {
            return this.internalHandler;
        }
        if (((Boolean)this.func_195044_w().func_177229_b((Property)CisternBlock.EXTENSION)).booleanValue()) {
            if (this.field_145850_b != null) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                if (te instanceof CisternTileEntity) {
                    CisternTileEntity parent = (CisternTileEntity)te;
                    this.invalidateHandlers();
                    this.internalHandler = parent.getInternalHandler();
                    parent.getPublicHandler().addListener(this.invalidationListener);
                    this.publicHandler = LazyOptional.of(() -> (IFluidHandler)this.internalHandler.orElse((Object)EmptyFluidHandler.INSTANCE));
                    this.renderIndex = parent.getRenderIndex() + 1;
                    return this.internalHandler;
                }
                if (!this.field_145850_b.func_201670_d()) {
                    Ceramics.LOG.error("Missing cistern tile entity below cistern extension");
                }
            } else {
                Ceramics.LOG.error("No world when trying to get cistern's fluid handler");
            }
        }
        this.internalHandler = this.publicHandler = LazyOptional.of(() -> this.tank);
        this.renderIndex = 0;
        return this.internalHandler;
    }

    public LazyOptional<IFluidHandler> getPublicHandler() {
        this.getInternalHandler();
        assert (this.publicHandler != null);
        return this.publicHandler;
    }

    public void randomTick() {
        if (this.cracksHandler.isActive()) {
            if (((Boolean)this.func_195044_w().func_177229_b((Property)CisternBlock.EXTENSION)).booleanValue()) {
                FluidStack fluid = ((IFluidHandler)this.getInternalHandler().orElse((Object)EmptyFluidHandler.INSTANCE)).getFluidInTank(0);
                int localAmount = fluid.getAmount() - this.capacityFor(this.renderIndex);
                if (localAmount > 0) {
                    this.cracksHandler.updateCracks(fluid.getFluid(), localAmount);
                } else {
                    this.cracksHandler.updateCracks(Fluids.field_204541_a, 0);
                }
            } else {
                FluidStack fluid = this.tank.getFluid();
                this.cracksHandler.updateCracks(fluid.getFluid(), Math.min(fluid.getAmount(), this.capacityPerLayer()));
            }
        }
    }

    protected void makeBase(FluidStack fluid, int extensions) {
        assert (this.field_145850_b != null);
        this.extensions = extensions;
        this.tank.setFluid(fluid);
        this.onTankChanged(true);
        this.invalidateHandlers();
        this.renderIndex = 0;
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CisternBlock.EXTENSION, (Comparable)Boolean.valueOf(false)));
    }

    public boolean containsFluid(FluidStack fluid) {
        return this.tank.getFluidAmount() == 0 || this.tank.getFluid().isFluidEqual(fluid);
    }

    protected void mergeCisterns(FluidStack fluid, int newExtensions) {
        this.extensions += newExtensions;
        if (!fluid.isEmpty()) {
            this.tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void makeExtension(CisternTileEntity parent) {
        assert (this.field_145850_b != null);
        FluidStack fluid = this.tank.getFluid();
        if (fluid.isEmpty() || parent.containsFluid(fluid)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CisternBlock.EXTENSION, (Comparable)Boolean.valueOf(true)));
            parent.mergeCisterns(fluid, this.extensions + 1);
            this.invalidateHandlers();
            this.extensions = 0;
            this.tank.setFluid(FluidStack.EMPTY);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getPublicHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.invalidateHandlers();
    }

    public void onTankChanged(boolean shouldRefreshCapabilities) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            CeramicsNetwork.getInstance().sendToClientsAround(new CisternUpdatePacket(this.field_174879_c, this.tank.getFluid(), shouldRefreshCapabilities), this.field_145850_b, this.field_174879_c);
        }
    }

    public void updateFluidTo(FluidStack fluid, boolean shouldRefreshCapabilities) {
        this.tank.setFluid(fluid);
        if (shouldRefreshCapabilities) {
            this.invalidateHandlers();
        }
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        this.extensions = tags.func_74762_e(TAG_EXTENSIONS);
        if (tags.func_150297_b(TAG_FLUID, 10)) {
            this.tank.readFromNBT(tags.func_74775_l(TAG_FLUID));
        }
        this.cracksHandler.readNBT(state, tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.tank.getFluidAmount() > 0) {
            compound.func_218657_a(TAG_FLUID, (INBT)this.tank.writeToNBT());
        }
        compound.func_74768_a(TAG_EXTENSIONS, this.extensions);
        this.cracksHandler.writeNBT(compound);
        return compound;
    }
}

