/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.tileentity;

import knightminer.ceramics.items.BaseClayBucketItem;
import knightminer.ceramics.items.CrackableBlockItem;
import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.network.CrackableCrackPacket;
import knightminer.ceramics.recipe.CeramicsTags;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.util.TileEntityHelper;

public class CrackableTileEntityHandler {
    public static final ModelProperty<Integer> PROPERTY = new ModelProperty(i -> i >= 0 && i <= 5);
    public static final String TAG_CRACKS = "cracks";
    private final MantleTileEntity parent;
    private final IModelData data = new SinglePropertyData(PROPERTY, (Object)0);
    private int cracks = 0;
    private boolean active;

    public CrackableTileEntityHandler(MantleTileEntity parent, boolean active) {
        this.parent = parent;
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void fluidAdded(FluidStack fluid) {
        if (this.active && this.cracks == 0 && BaseClayBucketItem.doesCrack(fluid.getFluid())) {
            this.setCracks(1);
        }
    }

    public void updateCracks(FluidStack fluid) {
        this.updateCracks(fluid.getFluid(), fluid.getAmount());
    }

    public void updateCracks(Fluid fluid, int relevantAmount) {
        if (this.active && BaseClayBucketItem.doesCrack(fluid)) {
            if (this.cracks >= 5) {
                World world = this.parent.func_145831_w();
                if (world != null) {
                    world.func_175655_b(this.parent.func_174877_v(), false);
                    if (relevantAmount > 1000) {
                        BlockState state = fluid.func_207188_f().func_206883_i();
                        if (state.func_177230_c() != Blocks.field_150350_a) {
                            world.func_175656_a(this.parent.func_174877_v(), state);
                        }
                    } else if (fluid instanceof FlowingFluid) {
                        int level = Math.max(1, relevantAmount * 8 / 1000);
                        BlockState state = ((FlowingFluid)fluid).func_207207_a(level, false).func_206883_i();
                        world.func_175656_a(this.parent.func_174877_v(), state);
                    }
                }
            } else {
                this.setCracks(this.cracks + 1);
            }
        }
    }

    private boolean setCracksRaw(int cracks) {
        if (cracks < 0) {
            cracks = 0;
        }
        if (cracks > 5) {
            cracks = 5;
        }
        if (cracks != this.cracks) {
            this.cracks = cracks;
            this.data.setData(PROPERTY, (Object)cracks);
            this.parent.requestModelDataUpdate();
            return true;
        }
        return false;
    }

    public void setCracks(int cracks) {
        if (this.active && this.setCracksRaw(cracks)) {
            this.parent.markDirtyFast();
            World world = this.parent.func_145831_w();
            if (world != null) {
                BlockPos pos = this.parent.func_174877_v();
                if (world.func_201670_d()) {
                    BlockState state = this.parent.func_195044_w();
                    world.func_184138_a(pos, state, state, 3);
                } else {
                    CeramicsNetwork.getInstance().sendToClientsAround(new CrackableCrackPacket(pos, this.cracks), world, pos);
                }
            }
        }
    }

    public int getCracks() {
        return this.cracks;
    }

    public IModelData getModelData() {
        return this.data;
    }

    public void setItemNBT(ItemStack stack) {
        if (this.active && this.cracks > 0) {
            stack.func_196082_o().func_74768_a(TAG_CRACKS, this.cracks);
        }
    }

    public void setCracks(ItemStack stack) {
        if (this.active) {
            this.setCracksRaw(CrackableBlockItem.getCracks(stack));
        }
    }

    public void readNBT(BlockState state, CompoundNBT nbt) {
        Block block = state.func_177230_c();
        if (block instanceof ICrackableBlock && ((ICrackableBlock)block).isCrackable()) {
            this.active = true;
            this.setCracksRaw(nbt.func_74762_e(TAG_CRACKS));
        } else {
            this.active = false;
            this.cracks = 0;
        }
    }

    public void writeNBT(CompoundNBT nbt) {
        if (this.active && this.cracks > 0) {
            nbt.func_74768_a(TAG_CRACKS, this.cracks);
        }
    }

    public static interface ICrackableTileEntity {
        public CrackableTileEntityHandler getCracksHandler();
    }

    public static interface ICrackableBlock {
        public boolean isCrackable();

        public static void onBlockPlacedBy(IWorld world, BlockPos pos, ItemStack stack) {
            TileEntityHelper.getTile(ICrackableTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> te.getCracksHandler().setCracks(stack));
        }

        public static boolean tryRepair(IWorld world, BlockPos pos, PlayerEntity player, Hand hand) {
            ItemStack held = player.func_184586_b(hand);
            if (held.func_77973_b().func_206844_a(CeramicsTags.Items.TERRACOTTA_CRACK_REPAIR)) {
                return TileEntityHelper.getTile(ICrackableTileEntity.class, (IBlockReader)world, (BlockPos)pos).filter(te -> {
                    CrackableTileEntityHandler handler = te.getCracksHandler();
                    int cracks = handler.getCracks();
                    if (handler.isActive() && cracks > 0) {
                        world.func_184133_a(player, pos, SoundType.field_185849_b.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        if (!world.func_201670_d()) {
                            handler.setCracks(Math.max(0, cracks - 3));
                            if (!player.func_184812_l_()) {
                                held.func_190918_g(1);
                                player.func_184611_a(hand, held);
                            }
                        }
                        return true;
                    }
                    return false;
                }).isPresent();
            }
            return false;
        }
    }
}

