/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.util.tank;

import knightminer.ceramics.tileentity.ChannelTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ChannelTank
extends FluidTank {
    private static final String TAG_LOCKED = "locked";
    private int locked;
    private final ChannelTileEntity parent;

    public ChannelTank(int capacity, ChannelTileEntity parent) {
        super(capacity, fluid -> !fluid.getFluid().getAttributes().isGaseous(fluid));
        this.parent = parent;
    }

    public void freeFluid() {
        this.locked = 0;
    }

    public int getMaxUsable() {
        return Math.max(this.fluid.getAmount() - this.locked, 0);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        boolean wasEmpty = this.isEmpty();
        int amount = super.fill(resource, action);
        if (action.execute()) {
            this.locked += amount;
            this.parent.getCracksHandler().fluidAdded(this.fluid);
            if (wasEmpty && !this.isEmpty()) {
                this.parent.sendFluidUpdate();
            }
        }
        return amount;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        boolean wasEmpty = this.isEmpty();
        FluidStack stack = super.drain(maxDrain, action);
        if (action.execute() && !wasEmpty && this.isEmpty()) {
            this.parent.sendFluidUpdate();
        }
        return stack;
    }

    public FluidTank readFromNBT(CompoundNBT nbt) {
        this.locked = nbt.func_74762_e(TAG_LOCKED);
        super.readFromNBT(nbt);
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74768_a(TAG_LOCKED, this.locked);
        return nbt;
    }
}

