/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.util.tank;

import javax.annotation.Nonnull;
import knightminer.ceramics.tileentity.CisternTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CisternTank
implements IFluidHandler,
IFluidTank {
    protected FluidStack fluid = FluidStack.EMPTY;
    protected final CisternTileEntity parent;

    public CisternTank(CisternTileEntity parent) {
        this.parent = parent;
    }

    public boolean isFluidValid(FluidStack stack) {
        return !stack.getFluid().getAttributes().isGaseous(stack);
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getCapacity() {
        return this.parent.capacityFor(this.parent.getExtensions() + 1);
    }

    public void validateAmount() {
        int extra = this.fluid.getAmount() - this.getCapacity();
        if (extra > 0) {
            this.drain(extra, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void setFluid(FluidStack stack) {
        this.fluid = stack;
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        int capacity = this.getCapacity();
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = new FluidStack(resource, Math.min(capacity, resource.getAmount()));
            this.parent.onFluidAdded(this.fluid.getAmount());
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(capacity);
        }
        if (filled > 0) {
            this.parent.onFluidAdded(filled);
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute() && drained > 0) {
            this.fluid.shrink(drained);
            this.parent.onTankChanged(false);
        }
        return stack;
    }

    public void readFromNBT(CompoundNBT nbt) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
        this.setFluid(fluid);
    }

    public CompoundNBT writeToNBT() {
        return this.fluid.writeToNBT(new CompoundNBT());
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }
}

