/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.function;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.function.Supplier;
import net.minecraft.util.math.MathHelper;

public interface VFXAlphaFunction<T extends EntityVisualFX> {
    public static final VFXAlphaFunction CONSTANT = (fx, alphaIn, pTicks) -> alphaIn;
    public static final VFXAlphaFunction FADE_OUT = (fx, alphaIn, pTicks) -> (1.0f - (float)fx.getAge() / (float)fx.getMaxAge()) * alphaIn;
    public static final VFXAlphaFunction PYRAMID = (fx, alphaIn, pTicks) -> {
        float halfAge = (float)fx.getMaxAge() / 2.0f;
        return (1.0f - Math.abs(halfAge - (float)fx.getAge()) / halfAge) * alphaIn;
    };

    public static <T extends EntityVisualFX> VFXAlphaFunction<T> proximity(Supplier<Vector3> targetSupplier, float distance) {
        return (fx, alpha, pTicks) -> alpha * MathHelper.func_76131_a((float)((float)fx.getRenderPosition(pTicks).distance((Vector3)targetSupplier.get()) / distance), (float)0.0f, (float)1.0f);
    }

    public float getAlpha(T var1, float var2, float var3);

    default public VFXAlphaFunction<T> andThen(VFXAlphaFunction<T> multiplied) {
        VFXAlphaFunction existing = this;
        return (fx, alphaIn, pTicks) -> multiplied.getAlpha(fx, existing.getAlpha(fx, alphaIn, pTicks), pTicks);
    }

    public static <T extends EntityVisualFX> VFXAlphaFunction<T> fadeIn(float fadeInTicks) {
        return (fx, alphaIn, pTicks) -> {
            if (fx.getAgeRefreshCount() > 0) {
                return alphaIn;
            }
            float mul = MathHelper.func_76131_a((float)((fadeInTicks - ((float)fx.getAge() + pTicks)) / fadeInTicks), (float)0.0f, (float)1.0f);
            return alphaIn * mul;
        };
    }
}

