/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.NavigationArrowScreen;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageAltarRecipe;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class ScreenJournalConstellationDetail
extends ScreenJournal
implements NavigationArrowScreen {
    private final ScreenJournal origin;
    private final IConstellation constellation;
    private final boolean detailed;
    private int doublePageID = 0;
    private int doublePages = 0;
    private List<MoonPhase> activePhases = null;
    private RenderablePage lastFramePage = null;
    private Rectangle rectBack;
    private Rectangle rectNext;
    private Rectangle rectPrev;
    private final List<IReorderingProcessor> locTextMain = new ArrayList<IReorderingProcessor>();
    private final List<IReorderingProcessor> locTextRitual = new ArrayList<IReorderingProcessor>();
    private final List<IReorderingProcessor> locTextRefraction = new ArrayList<IReorderingProcessor>();
    private final List<IReorderingProcessor> locTextMantle = new ArrayList<IReorderingProcessor>();

    public ScreenJournalConstellationDetail(ScreenJournal origin, IConstellation cst) {
        super((ITextComponent)cst.getConstellationName(), -1);
        this.origin = origin;
        this.constellation = cst;
        this.field_230712_o_ = Minecraft.func_71410_x().field_71466_p;
        this.detailed = ResearchHelper.getClientProgress().hasConstellationDiscovered(cst);
        PlayerProgress playerProgress = ResearchHelper.getClientProgress();
        if (this.detailed) {
            if (playerProgress.getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT)) {
                ++this.doublePages;
            }
            if (playerProgress.getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                if (!(this.constellation instanceof IMinorConstellation)) {
                    ++this.doublePages;
                }
                ++this.doublePages;
            }
        }
        this.testActivePhases();
        this.buildMainText();
        this.buildEnchText();
        this.buildRitualText();
        this.buildCapeText();
    }

    public IConstellation getConstellation() {
        return this.constellation;
    }

    private void buildCapeText() {
        if (this.constellation instanceof IWeakConstellation && ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
            ITextComponent txtMantle = ((IWeakConstellation)this.constellation).getInfoMantleEffect();
            TranslationTextComponent headTxt = new TranslationTextComponent("astralsorcery.journal.constellation.mantle");
            this.locTextMantle.add(this.localize((ITextProperties)headTxt));
            this.locTextMantle.add(IReorderingProcessor.field_242232_a);
            LinkedList<IReorderingProcessor> lines = new LinkedList<IReorderingProcessor>();
            for (String segment : txtMantle.getString().split("<NL>")) {
                lines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(segment), 175));
                lines.add(IReorderingProcessor.field_242232_a);
            }
            this.locTextMantle.addAll(lines);
            this.locTextMantle.add(IReorderingProcessor.field_242232_a);
        }
    }

    private void buildEnchText() {
        if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.CONSTELLATION_CRAFT)) {
            IFormattableTextComponent txtEnchantments = this.constellation.getConstellationEnchantmentDescription();
            TranslationTextComponent headTxt = new TranslationTextComponent("astralsorcery.journal.constellation.enchantments");
            this.locTextRefraction.add(this.localize((ITextProperties)headTxt));
            this.locTextRefraction.add(IReorderingProcessor.field_242232_a);
            LinkedList<IReorderingProcessor> lines = new LinkedList<IReorderingProcessor>();
            for (String segment : txtEnchantments.getString().split("<NL>")) {
                lines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(segment), 175));
                lines.add(IReorderingProcessor.field_242232_a);
            }
            this.locTextRefraction.addAll(lines);
            this.locTextRefraction.add(IReorderingProcessor.field_242232_a);
        }
    }

    private void buildRitualText() {
        if (this.constellation instanceof IMinorConstellation) {
            if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                ITextComponent txtRitual = ((IMinorConstellation)this.constellation).getInfoTraitEffect();
                TranslationTextComponent headTxt = new TranslationTextComponent("astralsorcery.journal.constellation.ritual.trait");
                this.locTextRitual.add(this.localize((ITextProperties)headTxt));
                this.locTextRitual.add(IReorderingProcessor.field_242232_a);
                LinkedList<IReorderingProcessor> lines = new LinkedList<IReorderingProcessor>();
                for (String segment : txtRitual.getString().split("<NL>")) {
                    lines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(segment), 175));
                    lines.add(IReorderingProcessor.field_242232_a);
                }
                this.locTextRitual.addAll(lines);
            }
        } else if (this.constellation instanceof IWeakConstellation) {
            LinkedList<IReorderingProcessor> lines;
            TranslationTextComponent headTxt;
            if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT)) {
                ITextComponent txtRitual = ((IWeakConstellation)this.constellation).getInfoRitualEffect();
                headTxt = new TranslationTextComponent("astralsorcery.journal.constellation.ritual");
                this.locTextRitual.add(this.localize((ITextProperties)headTxt));
                this.locTextRitual.add(IReorderingProcessor.field_242232_a);
                lines = new LinkedList<IReorderingProcessor>();
                for (String segment : txtRitual.getString().split("<NL>")) {
                    lines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(segment), 175));
                    lines.add(IReorderingProcessor.field_242232_a);
                }
                this.locTextRitual.addAll(lines);
                this.locTextRitual.add(IReorderingProcessor.field_242232_a);
            }
            if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                ITextComponent txtCorruptedRitual = ((IWeakConstellation)this.constellation).getInfoCorruptedRitualEffect();
                headTxt = new TranslationTextComponent("astralsorcery.journal.constellation.corruption");
                this.locTextRitual.add(this.localize((ITextProperties)headTxt));
                this.locTextRitual.add(IReorderingProcessor.field_242232_a);
                lines = new LinkedList();
                for (String segment : txtCorruptedRitual.getString().split("<NL>")) {
                    lines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(segment), 175));
                    lines.add(IReorderingProcessor.field_242232_a);
                }
                this.locTextRitual.addAll(lines);
                this.locTextRitual.add(IReorderingProcessor.field_242232_a);
            }
        }
    }

    private void buildMainText() {
        IFormattableTextComponent txtDescription = this.constellation.getConstellationDescription();
        LinkedList<IReorderingProcessor> lines = new LinkedList<IReorderingProcessor>();
        for (String segment : txtDescription.getString().split("<NL>")) {
            lines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(segment), 175));
            lines.add(IReorderingProcessor.field_242232_a);
        }
        this.locTextMain.addAll(lines);
    }

    private void testActivePhases() {
        WorldContext ctx = SkyHandler.getContext((World)Minecraft.func_71410_x().field_71441_e, LogicalSide.CLIENT);
        if (ctx == null) {
            return;
        }
        this.activePhases = new LinkedList<MoonPhase>();
        for (MoonPhase phase : MoonPhase.values()) {
            if (!ctx.getConstellationHandler().isActiveInPhase(this.constellation, phase)) continue;
            this.activePhases.add(phase);
        }
    }

    public void func_230430_a_(MatrixStack renderStack, int mouseX, int mouseY, float pTicks) {
        this.lastFramePage = null;
        if (this.doublePageID == 0) {
            this.drawCstBackground(renderStack);
            this.drawDefault(renderStack, TexturesAS.TEX_GUI_BOOK_FRAME_LEFT, mouseX, mouseY);
        } else {
            this.drawDefault(renderStack, TexturesAS.TEX_GUI_BOOK_BLANK, mouseX, mouseY);
        }
        this.drawNavArrows(renderStack, pTicks, mouseX, mouseY);
        this.func_230926_e_(120);
        switch (this.doublePageID) {
            case 0: {
                this.drawPageConstellation(renderStack, pTicks);
                this.drawPagePhaseInformation(renderStack);
                this.drawPageExtendedInformation(renderStack);
                break;
            }
            case 1: {
                this.drawRefractionTableInformation(renderStack, mouseX, mouseY, pTicks);
                break;
            }
            case 2: {
                this.drawCapeInformationPages(renderStack, mouseX, mouseY, pTicks);
                if (!(this.constellation instanceof IMinorConstellation)) break;
                this.drawConstellationPaperRecipePage(renderStack, mouseX, mouseY, pTicks);
                break;
            }
            case 3: {
                this.drawConstellationPaperRecipePage(renderStack, mouseX, mouseY, pTicks);
                break;
            }
        }
        this.func_230926_e_(0);
    }

    private void drawRefractionTableInformation(MatrixStack renderStack, int mouseX, int mouseY, float pTicks) {
        IReorderingProcessor line;
        int i;
        for (i = 0; i < this.locTextRitual.size(); ++i) {
            line = this.locTextRitual.get(i);
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(this.guiLeft + 30), (double)(this.guiTop + 30 + i * 10), (double)this.getGuiZLevel());
            RenderingDrawUtils.renderStringAt(line, renderStack, this.field_230712_o_, -3355444, true);
            renderStack.func_227865_b_();
        }
        for (i = 0; i < this.locTextRefraction.size(); ++i) {
            line = this.locTextRefraction.get(i);
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(this.guiLeft + 220), (double)(this.guiTop + 30 + i * 10), (double)this.getGuiZLevel());
            RenderingDrawUtils.renderStringAt(line, renderStack, this.field_230712_o_, -3355444, true);
            renderStack.func_227865_b_();
        }
    }

    private void drawCapeInformationPages(MatrixStack renderStack, int mouseX, int mouseY, float partialTicks) {
        SimpleAltarRecipe recipe;
        for (int i = 0; i < this.locTextMantle.size(); ++i) {
            IReorderingProcessor line = this.locTextMantle.get(i);
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(this.guiLeft + 30), (double)(this.guiTop + 30 + i * 10), (double)this.getGuiZLevel());
            RenderingDrawUtils.renderStringAt(line, renderStack, this.field_230712_o_, -3355444, true);
            renderStack.func_227865_b_();
        }
        if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT) && (recipe = RecipeHelper.findAltarRecipeResult(stack -> stack.func_77973_b() instanceof ItemMantle && this.constellation.equals(ItemsAS.MANTLE.getConstellation((ItemStack)stack)))) != null) {
            this.lastFramePage = new RenderPageAltarRecipe(null, -1, recipe);
            this.lastFramePage.render(renderStack, this.guiLeft + 220, this.guiTop + 20, this.getGuiZLevel(), partialTicks, mouseX, mouseY);
            this.lastFramePage.postRender(renderStack, this.guiLeft + 220, this.guiTop + 20, this.getGuiZLevel(), partialTicks, mouseX, mouseY);
        }
    }

    private void drawConstellationPaperRecipePage(MatrixStack renderStack, int mouseX, int mouseY, float partialTicks) {
        SimpleAltarRecipe recipe;
        if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT) && (recipe = RecipeHelper.findAltarRecipeResult(stack -> stack.func_77973_b() instanceof ItemConstellationPaper && this.constellation.equals(ItemsAS.CONSTELLATION_PAPER.getConstellation((ItemStack)stack)))) != null) {
            this.lastFramePage = new RenderPageAltarRecipe(null, -1, recipe);
            this.lastFramePage.render(renderStack, this.guiLeft + 30, this.guiTop + 20, this.getGuiZLevel(), partialTicks, mouseX, mouseY);
            this.lastFramePage.postRender(renderStack, this.guiLeft + 30, this.guiTop + 20, this.getGuiZLevel(), partialTicks, mouseX, mouseY);
        }
    }

    private void drawPageExtendedInformation(MatrixStack renderStack) {
        IFormattableTextComponent info = this.getConstellation().getConstellationTag();
        if (!this.detailed) {
            info = new TranslationTextComponent("astralsorcery.journal.constellation.unknown");
        }
        int width = this.field_230712_o_.func_238414_a_((ITextProperties)info);
        float chX = 305.0f - (float)width / 2.0f;
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)((float)this.guiLeft + chX), (double)(this.guiTop + 44), (double)this.getGuiZLevel());
        RenderingDrawUtils.renderStringAt(this.field_230712_o_, renderStack, (ITextProperties)info, -3355444);
        renderStack.func_227865_b_();
        if (this.detailed && !this.locTextMain.isEmpty()) {
            int offsetX = 220;
            int offsetY = 77;
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(this.guiLeft + offsetX), (double)(this.guiTop + offsetY), (double)this.getGuiZLevel());
            for (IReorderingProcessor line : this.locTextMain) {
                RenderingDrawUtils.renderStringAt(this.field_230712_o_, renderStack, line, -3355444);
                renderStack.func_227861_a_(0.0, 13.0, 0.0);
            }
            renderStack.func_227865_b_();
        }
    }

    private void drawPagePhaseInformation(MatrixStack renderStack) {
        List<MoonPhase> phases;
        if (this.activePhases == null) {
            this.testActivePhases();
            if (this.activePhases == null) {
                return;
            }
        }
        if ((phases = this.activePhases).isEmpty()) {
            TranslationTextComponent none = new TranslationTextComponent("astralsorcery.journal.constellation.unknown");
            float scale = 1.8f;
            float length = (float)this.field_230712_o_.func_238414_a_((ITextProperties)none) * scale;
            float offsetLeft = (float)(this.guiLeft + 296) - length / 2.0f;
            int offsetTop = this.guiTop + 199;
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(offsetLeft + 10.0f), (double)offsetTop, (double)this.getGuiZLevel());
            renderStack.func_227862_a_(scale, scale, scale);
            RenderingDrawUtils.renderStringAt((ITextProperties)none, renderStack, this.field_230712_o_, -857874979, true);
            renderStack.func_227865_b_();
        } else {
            boolean known = ResearchHelper.getClientProgress().hasConstellationDiscovered(this.constellation);
            int size = 19;
            int offsetX = 95 + this.field_230708_k_ / 2 - MoonPhase.values().length * (size + 2) / 2;
            int offsetY = 199 + this.guiTop;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            MoonPhase[] mPhases = MoonPhase.values();
            for (int i = 0; i < mPhases.length; ++i) {
                float brightness;
                MoonPhase phase = mPhases[i];
                int index = i;
                phase.getTexture().bindTexture();
                if (known && this.activePhases.contains((Object)phase)) {
                    Blending.PREALPHA.apply();
                    brightness = 1.0f;
                } else {
                    RenderSystem.defaultBlendFunc();
                    brightness = 0.7f;
                }
                RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, offsetX + index * (size + 2), offsetY, this.getGuiZLevel(), size, size).color(brightness, brightness, brightness, brightness).draw());
            }
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
        }
    }

    private void drawPageConstellation(MatrixStack renderStack, float partial) {
        IFormattableTextComponent cstName = this.constellation.getConstellationName();
        int width = this.field_230712_o_.func_238414_a_((ITextProperties)cstName);
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)((float)this.guiLeft + (305.0f - (float)width * 1.8f / 2.0f)), (double)(this.guiTop + 26), (double)this.getGuiZLevel());
        renderStack.func_227862_a_(1.8f, 1.8f, 1.0f);
        RenderingDrawUtils.renderStringAt((ITextProperties)cstName, renderStack, this.field_230712_o_, -3947581, true);
        renderStack.func_227865_b_();
        IFormattableTextComponent dstInfo = this.constellation.getConstellationTypeDescription();
        if (!this.detailed) {
            dstInfo = new TranslationTextComponent("astralsorcery.journal.constellation.unknown");
        }
        width = this.field_230712_o_.func_238414_a_((ITextProperties)dstInfo);
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)((float)this.guiLeft + (305.0f - (float)width / 2.0f)), (double)(this.guiTop + 219), (double)this.getGuiZLevel());
        RenderingDrawUtils.renderStringAt((ITextProperties)dstInfo, renderStack, this.field_230712_o_, -2236963, true);
        renderStack.func_227865_b_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Random rand = new Random(4726142277924544921L);
        boolean known = ResearchHelper.getClientProgress().hasConstellationDiscovered(this.constellation);
        RenderingConstellationUtils.renderConstellationIntoGUI(known ? this.constellation.getConstellationColor() : this.constellation.getTierRenderColor(), this.constellation, renderStack, this.guiLeft + 40, this.guiTop + 60, this.getGuiZLevel(), 150.0f, 150.0f, 2.0, () -> Float.valueOf(0.6f + 0.4f * RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), partial, 12 + rand.nextInt(10))), true, false);
        RenderSystem.disableBlend();
    }

    private void drawNavArrows(MatrixStack renderStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.rectNext = null;
        this.rectPrev = null;
        this.rectBack = this.drawArrow(renderStack, this.guiLeft + 197, this.guiTop + 230, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, partialTicks);
        if (this.doublePageID - 1 >= 0) {
            this.rectPrev = this.drawArrow(renderStack, this.guiLeft + 25, this.guiTop + 220, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, partialTicks);
        }
        if (this.doublePageID + 1 <= this.doublePages) {
            this.rectNext = this.drawArrow(renderStack, this.guiLeft + 367, this.guiTop + 220, this.getGuiZLevel(), NavigationArrowScreen.Type.RIGHT, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
    }

    private void drawCstBackground(MatrixStack renderStack) {
        TexturesAS.TEX_BLACK.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + 240), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 200), (float)(this.guiTop + 240), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 200), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        TexturesAS.TEX_GUI_BACKGROUND_CONSTELLATIONS.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + 240), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.5f).func_225583_a_(0.3f, 0.9f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 200), (float)(this.guiTop + 240), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.5f).func_225583_a_(0.7f, 0.9f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 200), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.5f).func_225583_a_(0.7f, 0.1f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.5f).func_225583_a_(0.3f, 0.1f).func_181675_d();
        });
        RenderSystem.disableBlend();
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return true;
    }

    public void func_231175_as__() {
        Minecraft.func_71410_x().func_147108_a((Screen)this.origin);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton != 0) {
            return false;
        }
        if (this.handleBookmarkClick(mouseX, mouseY)) {
            return true;
        }
        if (this.rectBack != null && this.rectBack.contains(mouseX, mouseY)) {
            Minecraft.func_71410_x().func_147108_a((Screen)this.origin);
            return true;
        }
        if (this.rectPrev != null && this.rectPrev.contains(mouseX, mouseY)) {
            if (this.doublePageID >= 1) {
                --this.doublePageID;
            }
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.rectNext != null && this.rectNext.contains(mouseX, mouseY)) {
            if (this.doublePageID <= this.doublePages - 1) {
                ++this.doublePageID;
            }
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        return this.doublePageID != 0 && this.lastFramePage != null && this.lastFramePage.propagateMouseClick(mouseX, mouseY);
    }
}

