/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal.overlay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.overlay.ScreenJournalOverlay;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeMap;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeInterpreter;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeReader;
import hellfirepvp.astralsorcery.common.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.perk.type.vanilla.VanillaPerkAttributeType;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.LogicalSide;

public class ScreenJournalOverlayPerkStatistics
extends ScreenJournalOverlay {
    private static final int HEADER_WIDTH = 190;
    private static final int DEFAULT_WIDTH = 175;
    private final List<PerkStatistic> statistics = new LinkedList<PerkStatistic>();
    private int nameStrWidth = -1;
    private int valueStrWidth = -1;
    private int suffixStrWidth = -1;

    public ScreenJournalOverlayPerkStatistics(ScreenJournal origin) {
        super((ITextComponent)new TranslationTextComponent("screen.astralsorcery.tome.perks.stats"), origin);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.statistics.clear();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        PerkAttributeInterpreter interpreter = PerkAttributeInterpreter.defaultInterpreter((PlayerEntity)player);
        RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValues().stream().filter(t -> t instanceof VanillaPerkAttributeType).forEach(arg_0 -> ScreenJournalOverlayPerkStatistics.lambda$init$1((PlayerEntity)player, arg_0));
        for (PerkAttributeType type : RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValues()) {
            PerkStatistic strPerkStat;
            if (!type.hasTypeApplied((PlayerEntity)player, LogicalSide.CLIENT) || (strPerkStat = interpreter.getValue(type)) == null) continue;
            this.statistics.add(strPerkStat);
        }
        this.statistics.sort(Comparator.comparing(perkStatistic -> I18n.func_135052_a((String)perkStatistic.getUnlocPerkTypeName(), (Object[])new Object[0])));
    }

    @Override
    public void func_230430_a_(MatrixStack renderStack, int mouseX, int mouseY, float pTicks) {
        super.func_230430_a_(renderStack, mouseX, mouseY, pTicks);
        float width = 275.0f;
        float height = 344.0f;
        this.func_230926_e_(150);
        TexturesAS.TEX_GUI_PARCHMENT_BLANK.bindTexture();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderingGuiUtils.drawRect(renderStack, (float)this.guiLeft + (float)this.guiWidth / 2.0f - width / 2.0f, (float)this.guiTop + (float)this.guiHeight / 2.0f - height / 2.0f, this.getGuiZLevel(), width, height);
        RenderSystem.disableBlend();
        this.func_230926_e_(0);
        this.drawHeader(renderStack);
        this.drawPageText(renderStack, mouseX, mouseY);
    }

    private void drawHeader(MatrixStack renderStack) {
        TranslationTextComponent title = new TranslationTextComponent("perk.reader.astralsorcery.gui");
        List lines = this.field_230712_o_.func_238425_b_((ITextProperties)title, MathHelper.func_76141_d((float)135.7143f));
        int step = 14;
        float offsetTop = (float)(this.guiTop + 15) - (float)(lines.size() * step) / 2.0f;
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(0.0, (double)offsetTop, 0.0);
        for (int i = 0; i < lines.size(); ++i) {
            IReorderingProcessor line = (IReorderingProcessor)lines.get(i);
            float offsetLeft = (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_243245_a(line) * 1.4f / 2.0f;
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)offsetLeft, (double)(i * step), 0.0);
            renderStack.func_227862_a_(1.4f, 1.4f, 1.0f);
            RenderingDrawUtils.renderStringAt(line, renderStack, this.field_230712_o_, -298634445, false);
            renderStack.func_227865_b_();
        }
        renderStack.func_227865_b_();
    }

    private void drawPageText(MatrixStack renderStack, int mouseX, int mouseY) {
        if (this.nameStrWidth == -1 || this.valueStrWidth == -1 || this.suffixStrWidth == -1) {
            this.buildDisplayWidth();
        }
        HashMap valueStrMap = Maps.newHashMap();
        int offsetY = this.guiTop + 40;
        int offsetX = this.guiLeft + this.guiWidth / 2 - 87;
        int line = 0;
        for (PerkStatistic stat : this.statistics) {
            TranslationTextComponent statName = new TranslationTextComponent(stat.getUnlocPerkTypeName());
            List statistics = this.field_230712_o_.func_238425_b_((ITextProperties)statName, MathHelper.func_76141_d((float)126.666664f));
            for (int i = 0; i < statistics.size(); ++i) {
                IReorderingProcessor statistic = (IReorderingProcessor)statistics.get(i);
                int drawX = offsetX;
                if (i > 0) {
                    drawX += 10;
                }
                renderStack.func_227860_a_();
                renderStack.func_227861_a_((double)drawX, (double)(offsetY + (line + i) * 10), (double)this.getGuiZLevel());
                RenderingDrawUtils.renderStringAt(statistic, renderStack, this.field_230712_o_, -298634445, false);
                renderStack.func_227865_b_();
            }
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(offsetX + this.nameStrWidth), (double)(offsetY + line * 10), (double)this.getGuiZLevel());
            RenderingDrawUtils.renderStringAt((ITextProperties)new StringTextComponent(stat.getPerkValue()), renderStack, this.field_230712_o_, -298634445, false);
            renderStack.func_227865_b_();
            int strLength = this.field_230712_o_.func_78256_a(stat.getPerkValue());
            Rectangle rctValue = new Rectangle(offsetX + this.nameStrWidth, offsetY + line * 10, strLength, 8);
            valueStrMap.put(rctValue, stat);
            line += statistics.size();
            if (stat.getSuffix().isEmpty()) continue;
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)(offsetX + 25), (double)(offsetY + line * 10), (double)this.getGuiZLevel());
            RenderingDrawUtils.renderStringAt((ITextProperties)new StringTextComponent(stat.getSuffix()), renderStack, this.field_230712_o_, -298634445, false);
            renderStack.func_227865_b_();
            ++line;
        }
        for (Rectangle rct : valueStrMap.keySet()) {
            if (!rct.contains(mouseX, mouseY)) continue;
            PerkStatistic stat = (PerkStatistic)valueStrMap.get(rct);
            this.drawCalculationDescription(renderStack, rct.x + rct.width + 2, rct.y + 15, stat);
        }
    }

    private void drawCalculationDescription(MatrixStack renderStack, int x, int y, PerkStatistic stat) {
        PerkAttributeType type = stat.getType();
        PerkAttributeReader reader = type.getReader();
        if (reader == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        PerkAttributeMap attrMap = PerkAttributeHelper.getOrCreateMap((PlayerEntity)player, LogicalSide.CLIENT);
        ArrayList information = Lists.newArrayList();
        information.add(new TranslationTextComponent("perk.reader.astralsorcery.description.head", new Object[]{PerkAttributeReader.formatDecimal(reader.getDefaultValue(attrMap, (PlayerEntity)player, LogicalSide.CLIENT))}));
        information.add(new TranslationTextComponent("perk.reader.astralsorcery.description.addition", new Object[]{PerkAttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (PlayerEntity)player, LogicalSide.CLIENT, ModifierType.ADDITION) - 1.0)}));
        information.add(new TranslationTextComponent("perk.reader.astralsorcery.description.increase", new Object[]{PerkAttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (PlayerEntity)player, LogicalSide.CLIENT, ModifierType.ADDED_MULTIPLY))}));
        information.add(new TranslationTextComponent("perk.reader.astralsorcery.description.moreless", new Object[]{PerkAttributeReader.formatDecimal(reader.getModifierValueForMode(attrMap, (PlayerEntity)player, LogicalSide.CLIENT, ModifierType.STACKING_MULTIPLY))}));
        if (!stat.getSuffix().isEmpty() || !stat.getPostProcessInfo().isEmpty()) {
            information.add(StringTextComponent.field_240750_d_);
        }
        if (!stat.getSuffix().isEmpty()) {
            information.add(new StringTextComponent(stat.getSuffix()));
        }
        if (!stat.getPostProcessInfo().isEmpty()) {
            information.add(new StringTextComponent(stat.getPostProcessInfo()));
        }
        RenderingDrawUtils.renderBlueTooltipComponents(renderStack, x, y, this.getGuiZLevel(), information, this.field_230712_o_, false);
    }

    private void buildDisplayWidth() {
        this.nameStrWidth = -1;
        this.valueStrWidth = -1;
        this.suffixStrWidth = -1;
        for (PerkStatistic stat : this.statistics) {
            TranslationTextComponent typeName = new TranslationTextComponent(stat.getUnlocPerkTypeName());
            int nameWidth = Math.min(this.field_230712_o_.func_238414_a_((ITextProperties)typeName), 126);
            int valueWidth = this.field_230712_o_.func_78256_a(stat.getPerkValue());
            int suffixWidth = this.field_230712_o_.func_78256_a(stat.getSuffix());
            if (nameWidth > this.nameStrWidth) {
                this.nameStrWidth = nameWidth;
            }
            if (valueWidth > this.valueStrWidth) {
                this.valueStrWidth = valueWidth;
            }
            if (suffixWidth <= this.suffixStrWidth) continue;
            this.suffixStrWidth = suffixWidth;
        }
        this.nameStrWidth += 6;
        this.valueStrWidth += 6;
        this.suffixStrWidth += 6;
    }

    private static /* synthetic */ void lambda$init$1(PlayerEntity player, PerkAttributeType t) {
        ((VanillaPerkAttributeType)((Object)t)).refreshAttribute(player);
    }
}

