/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.charge;

import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncCharge;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.key.KeyChargeBalancing;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class AlignmentChargeHandler
implements ITickHandler {
    public static final AlignmentChargeHandler INSTANCE = new AlignmentChargeHandler();
    private static final float MAX_CHARGE = 1000.0f;
    private static final Map<LogicalSide, Map<UUID, Float>> maximumCharge = new HashMap<LogicalSide, Map<UUID, Float>>();
    private static final Map<LogicalSide, Map<UUID, Float>> currentCharge = new HashMap<LogicalSide, Map<UUID, Float>>();

    private AlignmentChargeHandler() {
    }

    public void updateMaximum(PlayerEntity player, LogicalSide side) {
        float cap = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), PerkAttributeTypesAS.ATTR_TYPE_ALIGNMENT_CHARGE_MAXIMUM, 1000.0f);
        cap = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_ALIGNMENT_CHARGE_MAXIMUM, cap);
        cap = Math.max(0.0f, cap);
        maximumCharge.computeIfAbsent(side, s -> new HashMap()).put(player.func_110124_au(), Float.valueOf(cap));
        if (this.getCurrentCharge(player, side) > cap) {
            currentCharge.computeIfAbsent(side, s -> new HashMap()).put(player.func_110124_au(), Float.valueOf(cap));
        }
    }

    public float getMaximumCharge(PlayerEntity player, LogicalSide side) {
        return maximumCharge.computeIfAbsent(side, s -> new HashMap()).computeIfAbsent(player.func_110124_au(), uuid -> Float.valueOf(1000.0f)).floatValue();
    }

    public float getCurrentCharge(PlayerEntity player, LogicalSide side) {
        if (player.func_184812_l_() || player.func_175149_v()) {
            return this.getMaximumCharge(player, side);
        }
        return currentCharge.computeIfAbsent(side, s -> new HashMap()).computeIfAbsent(player.func_110124_au(), uuid -> Float.valueOf(1000.0f)).floatValue();
    }

    public float getFilledPercentage(PlayerEntity player, LogicalSide side) {
        if (player.func_184812_l_() || player.func_175149_v()) {
            return 1.0f;
        }
        float max = this.getMaximumCharge(player, side);
        float current = this.getCurrentCharge(player, side);
        return MathHelper.func_76131_a((float)(current / max), (float)0.0f, (float)1.0f);
    }

    public boolean hasCharge(PlayerEntity player, LogicalSide side, float charge) {
        if (player.func_184812_l_() || player.func_175149_v()) {
            return true;
        }
        float current = this.getCurrentCharge(player, side);
        return current >= charge;
    }

    public boolean drainCharge(PlayerEntity player, LogicalSide side, float charge, boolean simulate) {
        if (player.func_184812_l_() || player.func_175149_v()) {
            return true;
        }
        if (!this.hasCharge(player, side, charge)) {
            return false;
        }
        float current = this.getCurrentCharge(player, side);
        float result = current - charge;
        if (result < 0.0f) {
            return false;
        }
        if (!simulate) {
            currentCharge.computeIfAbsent(side, s -> new HashMap()).put(player.func_110124_au(), Float.valueOf(MathHelper.func_76131_a((float)result, (float)0.0f, (float)this.getMaximumCharge(player, side))));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receiveCharge(PktSyncCharge pkt, PlayerEntity player) {
        maximumCharge.computeIfAbsent(LogicalSide.CLIENT, s -> new HashMap()).put(player.func_110124_au(), Float.valueOf(pkt.getMaxCharge()));
        currentCharge.computeIfAbsent(LogicalSide.CLIENT, s -> new HashMap()).put(player.func_110124_au(), Float.valueOf(pkt.getCharge()));
    }

    public void tick(TickEvent.Type type, Object ... context) {
        float caveMultiplier;
        float max;
        PlayerEntity player = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        float charge = this.getCurrentCharge(player, side);
        if (charge >= (max = this.getMaximumCharge(player, side))) {
            return;
        }
        PlayerProgress progress = ResearchHelper.getProgress(player, side);
        float regenPerTick = max / 120.0f;
        boolean underground = player.func_130014_f_().func_205770_a(Heightmap.Type.WORLD_SURFACE, player.func_233580_cy_()).func_177956_o() > player.func_233580_cy_().func_177956_o() + 1;
        float dayMultiplier = underground ? 0.85f : 0.3f + 0.7f * DayTimeHelper.getCurrentDaytimeDistribution(player.func_130014_f_());
        float f = caveMultiplier = underground ? 0.25f : 1.0f;
        if (progress.getPerkData().hasPerkEffect(p -> p instanceof KeyChargeBalancing)) {
            dayMultiplier = 0.6f + dayMultiplier * 0.4f;
            caveMultiplier = 0.6f + caveMultiplier * 0.4f;
        }
        regenPerTick *= dayMultiplier;
        regenPerTick *= caveMultiplier;
        regenPerTick = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, progress, PerkAttributeTypesAS.ATTR_TYPE_ALIGNMENT_CHARGE_REGENERATION, regenPerTick);
        regenPerTick = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_ALIGNMENT_CHARGE_REGENERATION, regenPerTick);
        currentCharge.computeIfAbsent(side, s -> new HashMap()).put(player.func_110124_au(), Float.valueOf(Math.min(charge += regenPerTick, max)));
        PacketChannel.CHANNEL.sendToPlayer(player, new PktSyncCharge(player));
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Alignment Charge Handler";
    }
}

