/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.cmd.sub;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockStateHelper;
import hellfirepvp.astralsorcery.common.util.data.JsonHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandSerialize {
    private CommandSerialize() {
    }

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"serialize").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"hand").executes(CommandSerialize::serializeHand))).then(Commands.func_197057_a((String)"look").executes(CommandSerialize::serializeLook));
    }

    private static int serializeHand(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ItemStack held = player.func_184614_ca();
        String serialized = JsonHelper.serializeItemStack(held).toString();
        StringTextComponent msg = new StringTextComponent(serialized);
        Style s = Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Copy"))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, serialized));
        msg.func_230530_a_(s);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)msg, true);
        return 1;
    }

    private static int serializeLook(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        BlockRayTraceResult result = MiscUtils.rayTraceLookBlock((PlayerEntity)player);
        BlockState state = result == null ? Blocks.field_150350_a.func_176223_P() : player.func_130014_f_().func_180495_p(result.func_216350_a());
        String serialized = BlockStateHelper.serialize(state);
        StringTextComponent msg = new StringTextComponent(serialized);
        Style s = Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Copy"))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, serialized));
        msg.func_230530_a_(s);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)msg, true);
        return 1;
    }
}

