/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.world.WorldSeedCache;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class SkyHandler
implements ITickHandler {
    private static final SkyHandler instance = new SkyHandler();
    private final Map<RegistryKey<World>, WorldContext> worldHandlersServer = Maps.newHashMap();
    private final Map<RegistryKey<World>, WorldContext> worldHandlersClient = Maps.newHashMap();
    private final Map<RegistryKey<World>, Boolean> skyRevertMap = Maps.newHashMap();

    private SkyHandler() {
    }

    public static SkyHandler getInstance() {
        return instance;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        if (type == TickEvent.Type.WORLD) {
            World w = (World)context[0];
            if (!w.func_201670_d() && w instanceof ServerWorld) {
                RegistryKey dimKey = w.func_234923_W_();
                this.skyRevertMap.put((RegistryKey<World>)dimKey, false);
                WorldContext ctx = this.worldHandlersServer.get(dimKey);
                if (ctx == null) {
                    ctx = this.createContext(MiscUtils.getRandomWorldSeed((ISeedReader)((ServerWorld)w)));
                    this.worldHandlersServer.put((RegistryKey<World>)dimKey, ctx);
                }
                ctx.tick(w);
            }
        } else {
            this.handleClientTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClientTick() {
        ClientWorld w = Minecraft.func_71410_x().field_71441_e;
        if (w != null) {
            RegistryKey dimKey = w.func_234923_W_();
            WorldContext ctx = this.worldHandlersClient.get(dimKey);
            if (ctx == null) {
                Optional<Long> seedOpt = WorldSeedCache.getSeedIfPresent((RegistryKey<World>)dimKey);
                if (!seedOpt.isPresent()) {
                    return;
                }
                ctx = this.createContext(seedOpt.get());
                this.worldHandlersClient.put((RegistryKey<World>)dimKey, ctx);
            }
            ctx.tick((World)w);
        }
    }

    private WorldContext createContext(long seed) {
        return new WorldContext(seed);
    }

    @Nullable
    public static WorldContext getContext(World world) {
        return SkyHandler.getContext(world, world.func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER);
    }

    @Nullable
    public static WorldContext getContext(World world, LogicalSide dist) {
        if (world == null) {
            return null;
        }
        RegistryKey dimKey = world.func_234923_W_();
        if (dist.isClient()) {
            return SkyHandler.getInstance().worldHandlersClient.getOrDefault(dimKey, null);
        }
        return SkyHandler.getInstance().worldHandlersServer.getOrDefault(dimKey, null);
    }

    public void revertWorldTimeTick(ServerWorld world) {
        RegistryKey dimKey = world.func_234923_W_();
        Boolean state = this.skyRevertMap.get(dimKey);
        if (!world.field_72995_K && state != null && !state.booleanValue()) {
            this.skyRevertMap.put((RegistryKey<World>)dimKey, true);
            world.func_241114_a_(world.func_72820_D() - 1L);
        }
    }

    public void clientClearCache() {
        this.worldHandlersClient.clear();
    }

    public void informWorldUnload(World world) {
        this.worldHandlersServer.remove(world.func_234923_W_());
        this.worldHandlersClient.remove(world.func_234923_W_());
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD, TickEvent.Type.CLIENT);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "ConstellationSkyhandler";
    }
}

