/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectBootes
extends MantleEffect {
    public static BootesConfig CONFIG = new BootesConfig();

    public MantleEffectBootes() {
        super(ConstellationsAS.bootes);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(EventPriority.LOW, this::onHurt);
        bus.addListener(EventPriority.LOW, this::onAttacked);
    }

    @Override
    protected void tickServer(PlayerEntity player) {
        super.tickServer(player);
        ItemStack mantle = player.func_184582_a(EquipmentSlotType.CHEST);
        if (mantle.func_190926_b() || !(mantle.func_77973_b() instanceof ItemMantle)) {
            return;
        }
        World world = player.func_130014_f_();
        List<EntityFlare> flares = this.gatherFlares(world, mantle);
        if (flares.size() < (Integer)MantleEffectBootes.CONFIG.maxFlareCount.get() && player.field_70173_aa % 80 == 0 && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectBootes.CONFIG.chargeCostPerFlare.get()).intValue()) && rand.nextInt(4) == 0) {
            EntityFlare flare = (EntityFlare)EntityTypesAS.FLARE.func_200721_a(player.func_130014_f_());
            flare.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            flare.setFollowingTarget((LivingEntity)player);
            if (world.func_217376_c((Entity)flare)) {
                flares.add(flare);
                AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectBootes.CONFIG.chargeCostPerFlare.get()).intValue(), false);
            }
        }
        for (EntityFlare flare : flares) {
            if (flare.getFollowingTarget() == null || !(flare.func_70638_az() == null ? player.func_70032_d((Entity)flare) >= 12.0f : player.func_70032_d((Entity)flare) >= 35.0f)) continue;
            flare.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
        }
        this.setEntityIds(mantle, flares.stream().map(Entity::func_145782_y).collect(Collectors.toList()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        this.playCapeSparkles(player, 0.15f);
    }

    private void onAttacked(LivingAttackEvent event) {
        LivingEntity attacker;
        LivingEntity attacked = event.getEntityLiving();
        DamageSource src = event.getSource();
        if (!attacked.func_130014_f_().func_201670_d() && src.func_76346_g() instanceof LivingEntity && ItemMantle.getEffect(attacker = (LivingEntity)src.func_76346_g(), ConstellationsAS.bootes) != null && attacked.func_70089_S()) {
            if (attacked instanceof PlayerEntity && !MiscUtils.canPlayerAttackServer(attacker, attacked)) {
                return;
            }
            this.forEachFlare(attacker, flare -> flare.func_70624_b(attacked));
        }
    }

    private void onHurt(LivingHurtEvent event) {
        Entity source;
        LivingEntity hurt = event.getEntityLiving();
        if (!hurt.func_130014_f_().func_201670_d() && ItemMantle.getEffect(hurt, ConstellationsAS.bootes) != null && (source = event.getSource().func_76346_g()) instanceof LivingEntity) {
            this.forEachFlare(hurt, flare -> flare.func_70624_b((LivingEntity)source));
        }
    }

    protected void forEachFlare(LivingEntity owner, Consumer<EntityFlare> fn) {
        ItemStack mantle = owner.func_184582_a(EquipmentSlotType.CHEST);
        if (mantle.func_190926_b() || !(mantle.func_77973_b() instanceof ItemMantle)) {
            return;
        }
        this.gatherFlares(owner.func_130014_f_(), mantle).forEach(fn);
    }

    protected List<EntityFlare> gatherFlares(World world, ItemStack mantleStack) {
        ArrayList<EntityFlare> flares = new ArrayList<EntityFlare>();
        for (int flareId : this.getEntityIds(mantleStack)) {
            Entity e = world.func_73045_a(flareId);
            if (!(e instanceof EntityFlare) || !e.func_70089_S()) continue;
            flares.add((EntityFlare)e);
        }
        return flares;
    }

    protected void setEntityIds(ItemStack mantleStack, List<Integer> ids) {
        ListNBT list = new ListNBT();
        ids.forEach(i -> list.add((Object)IntNBT.func_229692_a_((int)i)));
        NBTHelper.getPersistentData(mantleStack).func_218657_a("flareIds", (INBT)list);
    }

    protected List<Integer> getEntityIds(ItemStack mantleStack) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ListNBT nbtIds = NBTHelper.getPersistentData(mantleStack).func_150295_c("flareIds", 3);
        for (int i = 0; i < nbtIds.size(); ++i) {
            ids.add(nbtIds.func_186858_c(i));
        }
        return ids;
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static class BootesConfig
    extends MantleEffect.Config {
        private final int defaultMaxFlareCount = 3;
        private final int defaultChargeCostPerFlare = 400;
        public ForgeConfigSpec.IntValue maxFlareCount;
        public ForgeConfigSpec.IntValue chargeCostPerFlare;

        public BootesConfig() {
            super("bootes");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.maxFlareCount = cfgBuilder.comment("Defines the maximum flare count the mantle can summon and keep following the wearer.").translation(this.translationKey("maxFlareCount")).defineInRange("maxFlareCount", this.defaultMaxFlareCount, 0, 6);
            this.chargeCostPerFlare = cfgBuilder.comment("Set the amount alignment charge consumed per created flare").translation(this.translationKey("chargeCostPerFlare")).defineInRange("chargeCostPerFlare", this.defaultChargeCostPerFlare, 0, 1000);
        }
    }
}

