/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.world;

import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.constellation.world.event.CelestialEvent;
import hellfirepvp.astralsorcery.common.constellation.world.event.LunarEclipse;
import hellfirepvp.astralsorcery.common.constellation.world.event.SolarEclipse;
import hellfirepvp.astralsorcery.common.constellation.world.event.StarFall;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.World;

public class CelestialEventHandler {
    private final WorldContext ctx;
    private final Set<CelestialEvent> events = new HashSet<CelestialEvent>();
    private final SolarEclipse solarEclipseEvent;
    private final LunarEclipse lunarEclipseEvent;
    private final StarFall starFallNight;

    CelestialEventHandler(WorldContext context) {
        this.ctx = context;
        this.solarEclipseEvent = this.addTrackedEvent(new SolarEclipse());
        this.lunarEclipseEvent = this.addTrackedEvent(new LunarEclipse());
        this.starFallNight = this.addTrackedEvent(new StarFall());
    }

    public <T extends CelestialEvent> T addTrackedEvent(T event) {
        this.events.add(event);
        return event;
    }

    public SolarEclipse getSolarEclipse() {
        return this.solarEclipseEvent;
    }

    public LunarEclipse getLunarEclipse() {
        return this.lunarEclipseEvent;
    }

    public StarFall getStarFallEvent() {
        return this.starFallNight;
    }

    public float getSolarEclipsePercent() {
        SolarEclipse solarEclipse = this.getSolarEclipse();
        if (!solarEclipse.isActiveNow()) {
            return 0.0f;
        }
        float halfDuration = (float)solarEclipse.getEventDuration() / 2.0f;
        float tick = solarEclipse.getEffectTick(0.0f) - halfDuration;
        return Math.abs(tick /= halfDuration);
    }

    void tick(World world) {
        for (CelestialEvent event : this.events) {
            event.tick(world, this.ctx.getRandom(event.getSeedModifier()), this.ctx);
        }
    }
}

