/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.world.event;

import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.constellation.world.event.CelestialEvent;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import java.util.Random;
import net.minecraft.world.World;

public class LunarEclipse
extends CelestialEvent {
    private boolean active = false;
    private boolean dayOfEvent = false;
    private int prevEventTick = 0;
    private int eventTick = 0;

    @Override
    public void tick(World world, Random rand, WorldContext ctx) {
        int suggestedDayLength;
        for (int i = 0; i < 12 + rand.nextInt(12); ++i) {
            rand.nextLong();
        }
        int halfTime = this.getEventDuration() / 2;
        int repeat = 68;
        long wTime = world.func_72820_D();
        int lunarTime = (int)(wTime % (long)(repeat * (suggestedDayLength = ((Integer)GeneralConfig.CONFIG.dayLength.get()).intValue())));
        this.dayOfEvent = lunarTime >= 0 && lunarTime < suggestedDayLength;
        int midLOffset = Math.round((float)suggestedDayLength * 0.75f);
        if (wTime > (long)suggestedDayLength && lunarTime > midLOffset - halfTime && lunarTime < midLOffset + halfTime) {
            this.active = true;
            this.prevEventTick = this.eventTick;
            this.eventTick = lunarTime - (midLOffset - halfTime);
        } else {
            this.active = false;
            this.prevEventTick = 0;
            this.eventTick = 0;
        }
    }

    @Override
    public boolean isActiveNow() {
        return this.active;
    }

    @Override
    public boolean isActiveDay() {
        return this.dayOfEvent;
    }

    @Override
    public float getEffectTick(float pTicks) {
        return (float)this.prevEventTick + (float)(this.eventTick - this.prevEventTick) * pTicks;
    }

    @Override
    public long getSeedModifier() {
        return -6515086094271922247L;
    }

    public int getEventDuration() {
        return (Integer)GeneralConfig.CONFIG.dayLength.get() / 5;
    }
}

