/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.builder;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeBuilder;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefaction;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WellRecipeBuilder
extends CustomRecipeBuilder<WellLiquefaction> {
    private final ResourceLocation id;
    private Ingredient input = Ingredient.field_193370_a;
    private Fluid output = Fluids.field_204541_a;
    private float productionMultiplier = 0.5f;
    private float shatterMultiplier = 15.0f;
    private Color catalystColor = Color.WHITE;

    private WellRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public static WellRecipeBuilder builder(ForgeRegistryEntry<?> nameProvider) {
        return new WellRecipeBuilder(AstralSorcery.key(nameProvider.getRegistryName().func_110623_a()));
    }

    public static WellRecipeBuilder builder(ResourceLocation id) {
        return new WellRecipeBuilder(id);
    }

    public WellRecipeBuilder setItemInput(IItemProvider item) {
        this.input = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        return this;
    }

    public WellRecipeBuilder setItemInput(Tag<Item> tag) {
        this.input = Ingredient.func_199805_a(tag);
        return this;
    }

    public WellRecipeBuilder setItemInput(Ingredient input) {
        this.input = input;
        return this;
    }

    public WellRecipeBuilder setLiquidOutput(Fluid output) {
        this.output = output;
        return this;
    }

    public WellRecipeBuilder color(Color color) {
        this.catalystColor = color;
        return this;
    }

    public WellRecipeBuilder productionMultiplier(float multiplier) {
        this.productionMultiplier = multiplier;
        return this;
    }

    public WellRecipeBuilder shatterMultiplier(float multiplier) {
        this.shatterMultiplier = multiplier;
        return this;
    }

    @Override
    @Nonnull
    protected WellLiquefaction validateAndGet() {
        if (this.input.func_203189_d()) {
            throw new IllegalArgumentException("No valid item for input found!");
        }
        if (this.output == Fluids.field_204541_a) {
            throw new IllegalArgumentException("No output fluid defined!");
        }
        return new WellLiquefaction(this.id, this.input, this.output, this.catalystColor, this.productionMultiplier, this.shatterMultiplier);
    }

    @Override
    protected CustomRecipeSerializer<WellLiquefaction> getSerializer() {
        return RecipeSerializersAS.WELL_LIQUEFACTION_SERIALIZER;
    }
}

