/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.meltable;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.nojson.meltable.WorldMeltableRecipe;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicates;
import hellfirepvp.astralsorcery.common.util.block.WorldBlockPos;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMeltableRecipe
extends WorldMeltableRecipe {
    private final BiFunction<WorldBlockPos, BlockState, ItemStack> outputGenerator;

    public ItemMeltableRecipe(ResourceLocation key, BlockPredicate matcher, ItemStack output) {
        this(key, matcher, (WorldBlockPos worldPos, BlockState state) -> ItemUtils.copyStackWithSize(output, output.func_190916_E()));
    }

    public ItemMeltableRecipe(ResourceLocation key, BlockPredicate matcher, BiFunction<WorldBlockPos, BlockState, ItemStack> outputGenerator) {
        super(key, matcher);
        this.outputGenerator = outputGenerator;
    }

    public static ItemMeltableRecipe of(BlockState stateIn, ItemStack itemOut) {
        return new ItemMeltableRecipe(AstralSorcery.key(stateIn.func_177230_c().getRegistryName().func_110623_a()), BlockPredicates.isState(stateIn), itemOut);
    }

    public static ItemMeltableRecipe of(ITag.INamedTag<Block> blockTagIn, ItemStack itemOut) {
        return new ItemMeltableRecipe(AstralSorcery.key(String.format("tag_%s", blockTagIn.func_230234_a_().func_110623_a())), BlockPredicates.isInTag(blockTagIn), itemOut);
    }

    @Override
    public void doOutput(World world, BlockPos pos, BlockState state, Consumer<ItemStack> itemOutput) {
        ItemStack generated;
        if (world.func_217377_a(pos, false) && !(generated = this.outputGenerator.apply(WorldBlockPos.wrapServer(world, pos), state)).func_190926_b()) {
            itemOutput.accept(generated);
        }
    }
}

