/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class AmuletEnchantmentEntry
implements ConfigDataSet,
Comparable<AmuletEnchantmentEntry> {
    private final Enchantment enchantment;
    private final int weight;

    public AmuletEnchantmentEntry(Enchantment ench, int weight) {
        this.enchantment = ench;
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @Override
    public int compareTo(AmuletEnchantmentEntry o) {
        return Integer.compare(this.weight, o.weight);
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.enchantment.getRegistryName().toString() + ";" + this.weight;
    }

    @Nullable
    public static AmuletEnchantmentEntry deserialize(String str) {
        int w;
        String[] spl = str.split(";");
        if (spl.length < 2) {
            return null;
        }
        String enchantmentKey = spl[0];
        String weight = spl[1];
        ResourceLocation registryName = new ResourceLocation(enchantmentKey);
        if (registryName.toString().equalsIgnoreCase("cofhcore:holding")) {
            AstralSorcery.log.info("Auto-ignoring amulet enchantment 'cofhcore:holding' as it's prone to cause issues.");
            return null;
        }
        Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(registryName);
        if (ench == null) {
            AstralSorcery.log.info("Ignoring whitelist entry " + str + " for amulet enchantments - Enchantment does not exist!");
            return null;
        }
        try {
            w = Integer.parseInt(weight);
        }
        catch (NumberFormatException exc) {
            AstralSorcery.log.info("Ignoring whitelist entry " + str + " for amulet enchantments - last :-separated argument is not a number!");
            return null;
        }
        return new AmuletEnchantmentEntry(ench, w);
    }
}

