/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.io.Files;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgressTestAccess;
import hellfirepvp.astralsorcery.common.data.research.ResearchIOThread;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.data.research.ResearchSyncHelper;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktProgressionUpdate;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncKnowledge;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class ResearchHelper {
    private static PlayerProgress clientProgress = new PlayerProgressTestAccess();
    private static final Map<UUID, PlayerProgress> playerProgressServer = new HashMap<UUID, PlayerProgress>();

    @Nonnull
    public static PlayerProgress getProgress(@Nullable PlayerEntity player, LogicalSide side) {
        if (side.isClient()) {
            return ResearchHelper.getClientProgress();
        }
        if (player instanceof ServerPlayerEntity) {
            return ResearchHelper.getProgressServer((ServerPlayerEntity)player);
        }
        return new PlayerProgressTestAccess();
    }

    @Nonnull
    public static PlayerProgress getClientProgress() {
        return clientProgress;
    }

    @Nonnull
    private static PlayerProgress getProgressServer(ServerPlayerEntity player) {
        if (MiscUtils.isPlayerFakeMP(player)) {
            return new PlayerProgressTestAccess();
        }
        return ResearchHelper.getProgress(player.func_110124_au());
    }

    @Nonnull
    private static PlayerProgress getProgress(UUID uuid) {
        PlayerProgress progress = playerProgressServer.get(uuid);
        if (progress == null) {
            ResearchHelper.loadPlayerKnowledge(uuid);
            progress = playerProgressServer.get(uuid);
        }
        if (progress == null) {
            progress = new PlayerProgress();
        }
        return progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateClientResearch(@Nullable PktSyncKnowledge pkt) {
        clientProgress = new PlayerProgress();
        if (pkt != null) {
            clientProgress.receive(pkt);
        }
    }

    public static void loadPlayerKnowledge(ServerPlayerEntity p) {
        if (!MiscUtils.isPlayerFakeMP(p)) {
            ResearchHelper.loadPlayerKnowledge(p.func_110124_au());
        }
    }

    private static void loadPlayerKnowledge(UUID pUUID) {
        File playerFile = ResearchHelper.getPlayerFile(pUUID);
        try {
            ResearchHelper.load_unsafe(pUUID, playerFile);
        }
        catch (Exception e) {
            AstralSorcery.log.warn("Unable to load progress from default progress file. Attempting loading backup.");
            AstralSorcery.log.warn("Erroneous file: " + playerFile.getName());
            e.printStackTrace();
            playerFile = ResearchHelper.getPlayerBackupFile(pUUID);
            try {
                ResearchHelper.load_unsafe(pUUID, playerFile);
                Files.copy((File)playerFile, (File)ResearchHelper.getPlayerFile(pUUID));
            }
            catch (Exception e1) {
                AstralSorcery.log.warn("Unable to load progress from backup progress file. Copying relevant files to error files.");
                AstralSorcery.log.warn("Erroneous file: " + playerFile.getName());
                e1.printStackTrace();
                File plOriginal = ResearchHelper.getPlayerFile(pUUID);
                File plBackup = ResearchHelper.getPlayerBackupFile(pUUID);
                try {
                    Files.copy((File)plOriginal, (File)new File(plOriginal.getParent(), plOriginal.getName() + ".lerror"));
                    Files.copy((File)plBackup, (File)new File(plBackup.getParent(), plBackup.getName() + ".lerror"));
                    AstralSorcery.log.warn("Copied progression files to error files. In case you would like to try me (HellFirePvP) to maybe see what i can do about maybe recovering the files,");
                    AstralSorcery.log.warn("send them over to me at the issue tracker https://github.com/HellFirePvP/AstralSorcery/issues - 90% that i won't be able to do anything, but reporting it would still be great.");
                }
                catch (IOException e2) {
                    AstralSorcery.log.warn("Unable to copy files to error-files.");
                    AstralSorcery.log.warn("I've had enough. I can't even access or open the files apparently. I'm giving up.");
                    e2.printStackTrace();
                }
                plOriginal.delete();
                plBackup.delete();
                ResearchHelper.informPlayersAboutProgressionLoss(pUUID);
                ResearchHelper.load_unsafeFromNBT(pUUID, null);
                ResearchHelper.savePlayerKnowledge(pUUID, true);
            }
        }
    }

    private static void load_unsafe(UUID pUUID, File playerFile) throws Exception {
        CompoundNBT compound = CompressedStreamTools.func_74797_a((File)playerFile);
        ResearchHelper.load_unsafeFromNBT(pUUID, compound);
    }

    private static void load_unsafeFromNBT(UUID pUUID, @Nullable CompoundNBT compound) {
        PlayerProgress progress = new PlayerProgress();
        if (compound != null && !compound.isEmpty()) {
            progress.load(compound);
        }
        progress.forceGainResearch(ResearchProgression.DISCOVERY);
        playerProgressServer.put(pUUID, progress);
    }

    private static void informPlayersAboutProgressionLoss(UUID pUUID) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server != null) {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(pUUID);
            if (player != null) {
                player.func_145747_a((ITextComponent)new StringTextComponent("AstralSorcery: Your progression could not be loaded and can't be recovered from backup. Please contact an administrator to lookup what went wrong and/or potentially recover your data from a backup.").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            String resolvedName = player != null ? player.func_146103_bH().getName() : pUUID.toString() + " (Not online)";
            for (String opName : server.func_184103_al().func_152606_n()) {
                ServerPlayerEntity pl = server.func_184103_al().func_152612_a(opName);
                if (pl == null) continue;
                pl.func_145747_a((ITextComponent)new StringTextComponent("AstralSorcery: The progression of " + resolvedName + " could not be loaded and can't be recovered from backup. Error files might be created from the unloadable progression files, check the console for additional information!").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        }
    }

    public static void sendConstellationDiscoveryMessage(ICommandSource src, IConstellation cst) {
        src.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.progress.constellation.discover.chat", new Object[]{cst.getConstellationName().func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.BLUE), Util.field_240973_b_);
    }

    public static void sendConstellationMemorizationMessage(ICommandSource src, PlayerProgress progress, IConstellation cst) {
        src.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.progress.constellation.seen.chat", new Object[]{cst.getConstellationName().func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.BLUE), Util.field_240973_b_);
        if (progress.getSeenConstellations().size() == 1) {
            src.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.progress.constellation.seen.track").func_240699_a_(TextFormatting.BLUE), Util.field_240973_b_);
        }
    }

    public static boolean mergeApplyPlayerprogress(PlayerProgress toMergeFrom, PlayerEntity player) {
        PlayerProgress progress = ResearchHelper.getProgress(player, LogicalSide.SERVER);
        if (!progress.isValid()) {
            return false;
        }
        progress.acceptMergeFrom(toMergeFrom);
        ResearchSyncHelper.pushProgressToClientUnsafe(progress, player);
        ResearchHelper.savePlayerKnowledge(player);
        return true;
    }

    public static void wipeKnowledge(ServerPlayerEntity p) {
        ResearchManager.resetPerks((PlayerEntity)p);
        ResearchHelper.wipeFile(p);
        playerProgressServer.remove(p.func_110124_au());
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)p, pkt);
        PktSyncKnowledge pk = new PktSyncKnowledge(1);
        PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)p, pk);
        ResearchHelper.loadPlayerKnowledge(p);
        ResearchSyncHelper.pushProgressToClientUnsafe(ResearchHelper.getProgressServer(p), (PlayerEntity)p);
    }

    private static void wipeFile(ServerPlayerEntity player) {
        ResearchHelper.getPlayerFile((PlayerEntity)player).delete();
        ResearchIOThread.cancelSave(player.func_110124_au());
    }

    public static void savePlayerKnowledge(PlayerEntity p) {
        if (p instanceof ServerPlayerEntity && !MiscUtils.isPlayerFakeMP((ServerPlayerEntity)p)) {
            ResearchHelper.savePlayerKnowledge(p.func_110124_au(), false);
        }
    }

    private static void savePlayerKnowledge(UUID pUUID, boolean force) {
        if (playerProgressServer.get(pUUID) == null) {
            return;
        }
        PlayerProgress progress = playerProgressServer.get(pUUID);
        if (force) {
            ResearchIOThread.saveNow(pUUID, progress);
        } else {
            ResearchIOThread.saveProgress(pUUID, progress.copy());
        }
    }

    public static void saveAndClearServerCache() {
        playerProgressServer.clear();
    }

    public static File getPlayerFile(PlayerEntity player) {
        return ResearchHelper.getPlayerFile(player.func_110124_au());
    }

    public static File getPlayerFile(UUID pUUID) {
        File f = new File(ResearchHelper.getPlayerDirectory(), pUUID.toString() + ".astral");
        if (!f.exists()) {
            try {
                CompressedStreamTools.func_74795_b((CompoundNBT)new CompoundNBT(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    public static boolean doesPlayerFileExist(PlayerEntity player) {
        return new File(ResearchHelper.getPlayerDirectory(), player.func_110124_au().toString() + ".astral").exists();
    }

    public static File getPlayerBackupFile(PlayerEntity player) {
        return ResearchHelper.getPlayerBackupFile(player.func_110124_au());
    }

    public static File getPlayerBackupFile(UUID pUUID) {
        File f = new File(ResearchHelper.getPlayerDirectory(), pUUID.toString() + ".astralback");
        if (!f.exists()) {
            try {
                CompressedStreamTools.func_74795_b((CompoundNBT)new CompoundNBT(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    private static File getPlayerDirectory() {
        File pDir = new File(AstralSorcery.getProxy().getASServerDataDirectory(), "playerdata");
        if (!pDir.exists()) {
            pDir.mkdirs();
        }
        return pDir;
    }
}

