/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.config.registry.AmuletEnchantmentRegistry;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantmentType;
import hellfirepvp.astralsorcery.common.item.ItemEnchantmentAmulet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;

public class AmuletRandomizeHelper {
    public static final Config CONFIG = new Config();
    private static final Random rand = new Random();
    private static ForgeConfigSpec.DoubleValue chance2nd;
    private static ForgeConfigSpec.DoubleValue chance3rd;
    private static ForgeConfigSpec.DoubleValue chance2Level;
    private static ForgeConfigSpec.DoubleValue chanceToAll;
    private static ForgeConfigSpec.DoubleValue chanceToNonExisting;

    public static void rollAmulet(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return;
        }
        ArrayList<AmuletEnchantment> ench = new ArrayList<AmuletEnchantment>();
        while (AmuletRandomizeHelper.mayGetAdditionalRoll(ench)) {
            DynamicEnchantmentType type = AmuletRandomizeHelper.getRollType(ench);
            if (type == null) continue;
            int lvl = AmuletRandomizeHelper.getRollLevel();
            if (type.isEnchantmentSpecific()) {
                Enchantment e = AmuletEnchantmentRegistry.getRandomEnchant();
                if (e == null) continue;
                ench.add(new AmuletEnchantment(type, e, lvl));
                continue;
            }
            ench.add(new AmuletEnchantment(type, lvl));
        }
        ItemEnchantmentAmulet.setAmuletEnchantments(stack, AmuletRandomizeHelper.collapseEnchantments(ench));
    }

    @Nullable
    private static DynamicEnchantmentType getRollType(List<AmuletEnchantment> existing) {
        int exAll = AmuletRandomizeHelper.getAdditionAll(existing);
        switch (existing.size()) {
            case 0: 
            case 1: {
                if ((double)rand.nextFloat() < (Double)chanceToAll.get()) {
                    return DynamicEnchantmentType.ADD_TO_EXISTING_ALL;
                }
                if ((double)rand.nextFloat() < (Double)chanceToNonExisting.get()) {
                    return DynamicEnchantmentType.ADD_TO_SPECIFIC;
                }
                return DynamicEnchantmentType.ADD_TO_EXISTING_SPECIFIC;
            }
            case 2: {
                if (exAll > 1) {
                    return null;
                }
                if (exAll == 1) {
                    if ((double)rand.nextFloat() < (Double)chanceToNonExisting.get()) {
                        return DynamicEnchantmentType.ADD_TO_SPECIFIC;
                    }
                    return DynamicEnchantmentType.ADD_TO_EXISTING_SPECIFIC;
                }
                if ((double)rand.nextFloat() < (Double)chanceToAll.get()) {
                    return DynamicEnchantmentType.ADD_TO_EXISTING_ALL;
                }
                if ((double)rand.nextFloat() < (Double)chanceToNonExisting.get()) {
                    return DynamicEnchantmentType.ADD_TO_SPECIFIC;
                }
                return DynamicEnchantmentType.ADD_TO_EXISTING_SPECIFIC;
            }
        }
        return null;
    }

    private static int getRollLevel() {
        if ((double)rand.nextFloat() < (Double)chance2Level.get()) {
            return 2;
        }
        return 1;
    }

    private static boolean mayGetAdditionalRoll(List<AmuletEnchantment> existing) {
        if (existing.isEmpty()) {
            return true;
        }
        switch (existing.size()) {
            case 1: {
                return (double)rand.nextFloat() < (Double)chance2nd.get();
            }
            case 2: {
                return AmuletRandomizeHelper.getAdditionAll(existing) < 2 && (double)rand.nextFloat() < (Double)chance3rd.get();
            }
        }
        return false;
    }

    private static int getAdditionAll(List<AmuletEnchantment> ench) {
        int i = 0;
        for (AmuletEnchantment e : ench) {
            if (!e.getType().equals((Object)DynamicEnchantmentType.ADD_TO_EXISTING_ALL)) continue;
            ++i;
        }
        return i;
    }

    private static List<AmuletEnchantment> collapseEnchantments(List<AmuletEnchantment> ench) {
        LinkedList<AmuletEnchantment> enchantments = new LinkedList<AmuletEnchantment>();
        for (AmuletEnchantment e : ench) {
            boolean found = false;
            for (AmuletEnchantment ex : enchantments) {
                if (!ex.canMerge(e)) continue;
                ex.merge(e);
                found = true;
                break;
            }
            if (found) continue;
            enchantments.add(e);
        }
        return enchantments;
    }

    public static class Config
    extends ConfigEntry {
        public Config() {
            super("enchantment_amulet");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            chance2nd = cfgBuilder.comment("Defines the chance to roll a 2nd-enchantment-manipulating roll on the amulet. Value defines a percent chance from 0% to 100%. Setting this to 0 also prevents a 3rd roll").translation(this.translationKey("chance2nd")).defineInRange("chance2nd", 0.8, 0.0, 1.0);
            chance3rd = cfgBuilder.comment("Defines the chance to roll a 3rd-enchantment-manipulation roll on the amulet. Value defines a percent chance from 0% to 100%.").translation(this.translationKey("chance3rd")).defineInRange("chance3rd", 0.25, 0.0, 1.0);
            chance2Level = cfgBuilder.comment("Defines the chance the roll will be +2 instead of +1 to existing enchantment/to enchantment/to all enchantments.").translation(this.translationKey("chance2Level")).defineInRange("chance2Level", 0.15, 0.0, 1.0);
            chanceToAll = cfgBuilder.comment("Defines the chance the amulet-roll 'to all existing enchantments' will appear.").translation(this.translationKey("chanceToAll")).defineInRange("chanceToAll", 0.02, 0.0, 1.0);
            chanceToNonExisting = cfgBuilder.comment("Defines the chance the amulet roll 'to <encahntment>' will appear. (Don't mistake this for 'to exsting <enchantment>'!)").translation(this.translationKey("chanceToNonExisting")).defineInRange("chanceToNonExisting", 0.35, 0.0, 1.0);
        }
    }
}

