/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.CooldownPerk;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import hellfirepvp.astralsorcery.common.util.tick.TimeoutListContainer;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class PerkCooldownHelper {
    private static final TimeoutListContainer<UUID, ResourceLocation> perkCooldowns = new TimeoutListContainer<UUID, ResourceLocation>(new PerkTimeoutHandler(LogicalSide.SERVER), TickEvent.Type.SERVER);
    private static final TimeoutListContainer<UUID, ResourceLocation> perkCooldownsClient = new TimeoutListContainer<UUID, ResourceLocation>(new PerkTimeoutHandler(LogicalSide.CLIENT), TickEvent.Type.CLIENT);

    private PerkCooldownHelper() {
    }

    public static void attachTickListeners(Consumer<ITickHandler> registrar) {
        registrar.accept(perkCooldowns);
        registrar.accept(perkCooldownsClient);
    }

    public static void clearCache(LogicalSide side) {
        if (side.isClient()) {
            perkCooldownsClient.clear();
        } else {
            perkCooldowns.clear();
        }
    }

    public static void removeAllCooldowns(PlayerEntity player, LogicalSide side) {
        UUID playerUUID = player.func_110124_au();
        if (side.isClient()) {
            if (perkCooldownsClient.hasList(playerUUID)) {
                perkCooldownsClient.removeList(playerUUID);
            }
        } else if (perkCooldowns.hasList(playerUUID)) {
            perkCooldowns.removeList(playerUUID);
        }
    }

    public static void removePerkCooldowns(LogicalSide side, AbstractPerk perk) {
        if (!(perk instanceof CooldownPerk)) {
            return;
        }
        TimeoutListContainer<UUID, ResourceLocation> container = side.isClient() ? perkCooldownsClient : perkCooldowns;
        container.removeList(key -> key.equals((Object)perk.getRegistryName()));
    }

    public static boolean isCooldownActiveForPlayer(PlayerEntity player, AbstractPerk perk) {
        if (!(perk instanceof CooldownPerk)) {
            return false;
        }
        TimeoutListContainer<UUID, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        UUID playerUUID = player.func_110124_au();
        return container.hasList(playerUUID) && container.getOrCreateList(playerUUID).contains(perk.getRegistryName());
    }

    public static void setCooldownActiveForPlayer(PlayerEntity player, AbstractPerk perk, int cooldownTicks) {
        if (!(perk instanceof CooldownPerk)) {
            return;
        }
        TimeoutListContainer<UUID, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        UUID playerUUID = player.func_110124_au();
        container.getOrCreateList(playerUUID).setOrAddTimeout(cooldownTicks, perk.getRegistryName());
    }

    public static void forceSetCooldownForPlayer(PlayerEntity player, AbstractPerk perk, int cooldownTicks) {
        UUID playerUUID;
        if (!(perk instanceof CooldownPerk)) {
            return;
        }
        TimeoutListContainer<UUID, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        if (!container.getOrCreateList(playerUUID = player.func_110124_au()).setTimeout(cooldownTicks, perk.getRegistryName())) {
            PerkCooldownHelper.setCooldownActiveForPlayer(player, perk, cooldownTicks);
        }
    }

    public static int getActiveCooldownForPlayer(PlayerEntity player, AbstractPerk perk) {
        UUID playerUUID;
        if (!(perk instanceof CooldownPerk)) {
            return -1;
        }
        TimeoutListContainer<UUID, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        if (!container.hasList(playerUUID = player.func_110124_au())) {
            return -1;
        }
        return container.getOrCreateList(playerUUID).getTimeout(perk.getRegistryName());
    }

    public static class PerkTimeoutHandler
    implements TimeoutListContainer.ContainerTimeoutDelegate<UUID, ResourceLocation> {
        private final LogicalSide side;

        public PerkTimeoutHandler(LogicalSide side) {
            this.side = side;
        }

        @Override
        public void onContainerTimeout(UUID playerUUID, ResourceLocation key) {
            PlayerEntity player = EntityUtils.getPlayer(playerUUID, this.side);
            if (player != null) {
                PerkTree.PERK_TREE.getPerk(this.side, key).ifPresent(perk -> {
                    if (perk instanceof CooldownPerk) {
                        ((CooldownPerk)((Object)perk)).onCooldownTimeout(player);
                    }
                });
            }
        }
    }
}

